/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.utils;

import com.clearspring.analytics.stream.cardinality.HyperLogLog;
import com.google.common.primitives.Longs;
import com.tdunning.math.stats.MergingDigest;
import com.tdunning.math.stats.TDigest;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.theta.Sketch;
import org.apache.pinot.segment.local.customobject.AvgPair;
import org.apache.pinot.segment.local.customobject.MinMaxRangePair;
import org.apache.pinot.segment.local.customobject.QuantileDigest;
import org.roaringbitmap.RoaringBitmap;

public class CustomSerDeUtils {
    public static final ObjectSerDe<String> STRING_SER_DE = new ObjectSerDe<String>(){

        @Override
        public byte[] serialize(String value) {
            return value.getBytes(StandardCharsets.UTF_8);
        }

        @Override
        public String deserialize(byte[] bytes) {
            return new String(bytes);
        }

        @Override
        public String deserialize(ByteBuffer byteBuffer) {
            byte[] bytes = new byte[byteBuffer.remaining()];
            byteBuffer.get(bytes);
            return new String(bytes, StandardCharsets.UTF_8);
        }
    };
    public static final ObjectSerDe<Long> LONG_SER_DE = new ObjectSerDe<Long>(){

        @Override
        public byte[] serialize(Long value) {
            return Longs.toByteArray((long)value);
        }

        @Override
        public Long deserialize(byte[] bytes) {
            return Longs.fromByteArray((byte[])bytes);
        }

        @Override
        public Long deserialize(ByteBuffer byteBuffer) {
            return byteBuffer.getLong();
        }
    };
    public static final ObjectSerDe<Double> DOUBLE_SER_DE = new ObjectSerDe<Double>(){

        @Override
        public byte[] serialize(Double value) {
            return Longs.toByteArray((long)Double.doubleToRawLongBits(value));
        }

        @Override
        public Double deserialize(byte[] bytes) {
            return Double.longBitsToDouble(Longs.fromByteArray((byte[])bytes));
        }

        @Override
        public Double deserialize(ByteBuffer byteBuffer) {
            return byteBuffer.getDouble();
        }
    };
    public static final ObjectSerDe<AvgPair> AVG_PAIR_SER_DE = new ObjectSerDe<AvgPair>(){

        @Override
        public byte[] serialize(AvgPair avgPair) {
            return avgPair.toBytes();
        }

        @Override
        public AvgPair deserialize(byte[] bytes) {
            return AvgPair.fromBytes(bytes);
        }

        @Override
        public AvgPair deserialize(ByteBuffer byteBuffer) {
            return AvgPair.fromByteBuffer(byteBuffer);
        }
    };
    public static final ObjectSerDe<MinMaxRangePair> MIN_MAX_RANGE_PAIR_SER_DE = new ObjectSerDe<MinMaxRangePair>(){

        @Override
        public byte[] serialize(MinMaxRangePair minMaxRangePair) {
            return minMaxRangePair.toBytes();
        }

        @Override
        public MinMaxRangePair deserialize(byte[] bytes) {
            return MinMaxRangePair.fromBytes(bytes);
        }

        @Override
        public MinMaxRangePair deserialize(ByteBuffer byteBuffer) {
            return MinMaxRangePair.fromByteBuffer(byteBuffer);
        }
    };
    public static final ObjectSerDe<HyperLogLog> HYPER_LOG_LOG_SER_DE = new ObjectSerDe<HyperLogLog>(){

        @Override
        public byte[] serialize(HyperLogLog hyperLogLog) {
            try {
                return hyperLogLog.getBytes();
            }
            catch (IOException e) {
                throw new RuntimeException("Caught exception while serializing HyperLogLog", e);
            }
        }

        @Override
        public HyperLogLog deserialize(byte[] bytes) {
            try {
                return HyperLogLog.Builder.build((byte[])bytes);
            }
            catch (IOException e) {
                throw new RuntimeException("Caught exception while de-serializing HyperLogLog", e);
            }
        }

        @Override
        public HyperLogLog deserialize(ByteBuffer byteBuffer) {
            byte[] bytes = new byte[byteBuffer.remaining()];
            byteBuffer.get(bytes);
            try {
                return HyperLogLog.Builder.build((byte[])bytes);
            }
            catch (IOException e) {
                throw new RuntimeException("Caught exception while de-serializing HyperLogLog", e);
            }
        }
    };
    public static final ObjectSerDe<TDigest> TDIGEST_SER_DE = new ObjectSerDe<TDigest>(){

        @Override
        public byte[] serialize(TDigest tDigest) {
            byte[] bytes = new byte[tDigest.byteSize()];
            tDigest.asBytes(ByteBuffer.wrap(bytes));
            return bytes;
        }

        @Override
        public TDigest deserialize(byte[] bytes) {
            return MergingDigest.fromBytes((ByteBuffer)ByteBuffer.wrap(bytes));
        }

        @Override
        public TDigest deserialize(ByteBuffer byteBuffer) {
            return MergingDigest.fromBytes((ByteBuffer)byteBuffer);
        }
    };
    public static final ObjectSerDe<Sketch> DATA_SKETCH_SER_DE = new ObjectSerDe<Sketch>(){

        @Override
        public byte[] serialize(Sketch value) {
            return value.compact(false, null).toByteArray();
        }

        @Override
        public Sketch deserialize(byte[] bytes) {
            return Sketch.wrap((Memory)Memory.wrap((byte[])bytes));
        }

        @Override
        public Sketch deserialize(ByteBuffer byteBuffer) {
            byte[] bytes = new byte[byteBuffer.remaining()];
            byteBuffer.get(bytes);
            return Sketch.wrap((Memory)Memory.wrap((byte[])bytes));
        }
    };
    public static final ObjectSerDe<RoaringBitmap> ROARING_BITMAP_SER_DE = new ObjectSerDe<RoaringBitmap>(){

        @Override
        public byte[] serialize(RoaringBitmap bitmap) {
            byte[] bytes = new byte[bitmap.serializedSizeInBytes()];
            ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
            bitmap.serialize(byteBuffer);
            return bytes;
        }

        @Override
        public RoaringBitmap deserialize(byte[] bytes) {
            return this.deserialize(ByteBuffer.wrap(bytes));
        }

        @Override
        public RoaringBitmap deserialize(ByteBuffer byteBuffer) {
            RoaringBitmap bitmap = new RoaringBitmap();
            try {
                bitmap.deserialize(byteBuffer);
            }
            catch (IOException e) {
                throw new RuntimeException("Caught exception while deserializing RoaringBitmap", e);
            }
            return bitmap;
        }
    };
    public static final ObjectSerDe<QuantileDigest> QUANTILE_DIGEST_SER_DE = new ObjectSerDe<QuantileDigest>(){

        @Override
        public byte[] serialize(QuantileDigest quantileDigest) {
            return quantileDigest.toBytes();
        }

        @Override
        public QuantileDigest deserialize(byte[] bytes) {
            return QuantileDigest.fromBytes(bytes);
        }

        @Override
        public QuantileDigest deserialize(ByteBuffer byteBuffer) {
            return QuantileDigest.fromByteBuffer(byteBuffer);
        }
    };

    private CustomSerDeUtils() {
    }

    public static interface ObjectSerDe<T> {
        public byte[] serialize(T var1);

        public T deserialize(byte[] var1);

        public T deserialize(ByteBuffer var1);
    }
}

