/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.utils;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.zip.Adler32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrcUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(CrcUtils.class);
    private static final int BUFFER_SIZE = 65536;
    private static final String CRC_FILE_EXTENSTION = ".crc";
    private final List<File> _files;

    private CrcUtils(List<File> files) {
        this._files = files;
    }

    public static CrcUtils forAllFilesInFolder(File dir) {
        ArrayList<File> normalFiles = new ArrayList<File>();
        CrcUtils.getAllNormalFiles(dir, normalFiles);
        Collections.sort(normalFiles);
        return new CrcUtils(normalFiles);
    }

    private static void getAllNormalFiles(File dir, List<File> normalFiles) {
        File[] files = dir.listFiles();
        Preconditions.checkNotNull((Object)files);
        for (File file : files) {
            if (file.isFile()) {
                if (file.getName().equals("creation.meta") || file.getName().endsWith(CRC_FILE_EXTENSTION)) continue;
                normalFiles.add(file);
                continue;
            }
            CrcUtils.getAllNormalFiles(file, normalFiles);
        }
    }

    public long computeCrc() throws IOException {
        byte[] buffer = new byte[65536];
        Adler32 checksum = new Adler32();
        for (File file : this._files) {
            try (FileInputStream input = new FileInputStream(file);){
                int len;
                while ((len = ((InputStream)input).read(buffer)) > 0) {
                    checksum.update(buffer, 0, len);
                }
            }
        }
        long crc = checksum.getValue();
        LOGGER.info("Computed crc = {}, based on files {}", (Object)crc, this._files);
        return crc;
    }

    public String computeMD5() throws NoSuchAlgorithmException, IOException {
        byte[] buffer = new byte[65536];
        MessageDigest digest = MessageDigest.getInstance("md5");
        for (File file : this._files) {
            try (FileInputStream input = new FileInputStream(file);){
                int len;
                while ((len = ((InputStream)input).read(buffer)) > 0) {
                    digest.update(buffer, 0, len);
                }
            }
        }
        String md5Value = CrcUtils.toHexaDecimal(digest.digest());
        LOGGER.info("Computed MD5 = {}, based on files {}", (Object)md5Value, this._files);
        return md5Value;
    }

    public static String toHexaDecimal(byte[] bytesToConvert) {
        char[] hexCharactersAsArray = "0123456789ABCDEF".toCharArray();
        char[] convertedHexCharsArray = new char[bytesToConvert.length * 2];
        for (int j = 0; j < bytesToConvert.length; ++j) {
            int v = bytesToConvert[j] & 0xFF;
            convertedHexCharsArray[j * 2] = hexCharactersAsArray[v >>> 4];
            convertedHexCharsArray[j * 2 + 1] = hexCharactersAsArray[v & 0xF];
        }
        return new String(convertedHexCharsArray);
    }
}

