/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.index.readers.text;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.file.Path;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.pinot.segment.local.segment.index.readers.text.LuceneDocIdCollector;
import org.apache.pinot.segment.local.segment.store.TextIndexUtils;
import org.apache.pinot.segment.spi.index.reader.TextIndexReader;
import org.apache.pinot.segment.spi.memory.PinotDataBuffer;
import org.apache.pinot.segment.spi.store.SegmentDirectoryPaths;
import org.roaringbitmap.buffer.ImmutableRoaringBitmap;
import org.roaringbitmap.buffer.MutableRoaringBitmap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LuceneTextIndexReader
implements TextIndexReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(LuceneTextIndexReader.class);
    private final IndexReader _indexReader;
    private final Directory _indexDirectory;
    private final IndexSearcher _indexSearcher;
    private final String _column;
    private final DocIdTranslator _docIdTranslator;
    private final StandardAnalyzer _standardAnalyzer;
    private boolean _useANDForMultiTermQueries = false;

    public LuceneTextIndexReader(String column, File indexDir, int numDocs, @Nullable Map<String, String> textIndexProperties) {
        this._column = column;
        try {
            File indexFile = this.getTextIndexFile(indexDir);
            this._indexDirectory = FSDirectory.open((Path)indexFile.toPath());
            this._indexReader = DirectoryReader.open((Directory)this._indexDirectory);
            this._indexSearcher = new IndexSearcher(this._indexReader);
            if (textIndexProperties == null || !Boolean.parseBoolean(textIndexProperties.get("enableQueryCacheForTextIndex"))) {
                this._indexSearcher.setQueryCache(null);
            }
            if (textIndexProperties != null && Boolean.parseBoolean(textIndexProperties.get("useANDForMultiTermTextIndexQueries"))) {
                this._useANDForMultiTermQueries = true;
            }
            this._docIdTranslator = new DocIdTranslator(indexDir, this._column, numDocs, this._indexSearcher);
            this._standardAnalyzer = TextIndexUtils.getStandardAnalyzerWithCustomizedStopWords(TextIndexUtils.extractStopWordsInclude(textIndexProperties), TextIndexUtils.extractStopWordsExclude(textIndexProperties));
        }
        catch (Exception e) {
            LOGGER.error("Failed to instantiate Lucene text index reader for column {}, exception {}", (Object)column, (Object)e.getMessage());
            throw new RuntimeException(e);
        }
    }

    private File getTextIndexFile(File segmentIndexDir) {
        File file = SegmentDirectoryPaths.findTextIndexIndexFile((File)segmentIndexDir, (String)this._column);
        if (file == null) {
            throw new IllegalStateException("Failed to find text index file for column: " + this._column);
        }
        return file;
    }

    public ImmutableRoaringBitmap getDictIds(String searchQuery) {
        throw new UnsupportedOperationException("");
    }

    public MutableRoaringBitmap getDocIds(String searchQuery) {
        MutableRoaringBitmap docIds = new MutableRoaringBitmap();
        LuceneDocIdCollector docIDCollector = new LuceneDocIdCollector(docIds, this._docIdTranslator);
        try {
            QueryParser parser = new QueryParser(this._column, (Analyzer)this._standardAnalyzer);
            if (this._useANDForMultiTermQueries) {
                parser.setDefaultOperator(QueryParser.Operator.AND);
            }
            Query query = parser.parse(searchQuery);
            this._indexSearcher.search(query, (Collector)docIDCollector);
            return docIds;
        }
        catch (Exception e) {
            String msg = "Caught excepttion while searching the text index for column:" + this._column + " search query:" + searchQuery;
            throw new RuntimeException(msg, e);
        }
    }

    public void close() throws IOException {
        this._indexReader.close();
        this._indexDirectory.close();
        this._docIdTranslator.close();
    }

    static class DocIdTranslator
    implements Closeable {
        final PinotDataBuffer _buffer;

        DocIdTranslator(File segmentIndexDir, String column, int numDocs, IndexSearcher indexSearcher) throws Exception {
            int length = 4 * numDocs;
            File docIdMappingFile = new File(SegmentDirectoryPaths.findSegmentDirectory((File)segmentIndexDir), column + ".lucene.mapping");
            String desc = "Text index docId mapping buffer: " + column;
            if (docIdMappingFile.exists()) {
                this._buffer = PinotDataBuffer.mapFile((File)docIdMappingFile, (boolean)true, (long)0L, (long)length, (ByteOrder)ByteOrder.LITTLE_ENDIAN, (String)desc);
            } else {
                this._buffer = PinotDataBuffer.mapFile((File)docIdMappingFile, (boolean)false, (long)0L, (long)length, (ByteOrder)ByteOrder.LITTLE_ENDIAN, (String)desc);
                for (int i = 0; i < numDocs; ++i) {
                    try {
                        Document document = indexSearcher.doc(i);
                        int pinotDocId = Integer.parseInt(document.get("DocID"));
                        this._buffer.putInt(i * 4, pinotDocId);
                        continue;
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Caught exception while building doc id mapping for text index column: " + column, e);
                    }
                }
            }
        }

        int getPinotDocId(int luceneDocId) {
            return this._buffer.getInt(luceneDocId * 4);
        }

        @Override
        public void close() throws IOException {
            this._buffer.close();
        }
    }
}

