/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.index.readers.text;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.ScoreMode;
import org.apache.pinot.segment.local.segment.index.readers.text.LuceneTextIndexReader;
import org.roaringbitmap.buffer.MutableRoaringBitmap;

public class LuceneDocIdCollector
implements Collector {
    private final MutableRoaringBitmap _docIds;
    private final LuceneTextIndexReader.DocIdTranslator _docIdTranslator;

    public LuceneDocIdCollector(MutableRoaringBitmap docIds, LuceneTextIndexReader.DocIdTranslator docIdTranslator) {
        this._docIds = docIds;
        this._docIdTranslator = docIdTranslator;
    }

    public ScoreMode scoreMode() {
        return ScoreMode.COMPLETE_NO_SCORES;
    }

    public LeafCollector getLeafCollector(final LeafReaderContext context) {
        return new LeafCollector(){

            public void setScorer(Scorable scorer) throws IOException {
            }

            public void collect(int doc) throws IOException {
                LuceneDocIdCollector.this._docIds.add(LuceneDocIdCollector.this._docIdTranslator.getPinotDocId(context.docBase + doc));
            }
        };
    }
}

