/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.index.readers.json;

import com.google.common.base.Preconditions;
import java.nio.ByteOrder;
import java.util.List;
import org.apache.pinot.common.request.Expression;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.request.context.FilterContext;
import org.apache.pinot.common.request.context.RequestContextUtils;
import org.apache.pinot.common.request.context.predicate.EqPredicate;
import org.apache.pinot.common.request.context.predicate.InPredicate;
import org.apache.pinot.common.request.context.predicate.NotEqPredicate;
import org.apache.pinot.common.request.context.predicate.NotInPredicate;
import org.apache.pinot.common.request.context.predicate.Predicate;
import org.apache.pinot.segment.local.segment.index.readers.BitmapInvertedIndexReader;
import org.apache.pinot.segment.local.segment.index.readers.StringDictionary;
import org.apache.pinot.segment.spi.index.reader.JsonIndexReader;
import org.apache.pinot.segment.spi.memory.PinotDataBuffer;
import org.apache.pinot.spi.exception.BadQueryRequestException;
import org.apache.pinot.sql.parsers.CalciteSqlParser;
import org.roaringbitmap.buffer.ImmutableRoaringBitmap;
import org.roaringbitmap.buffer.MutableRoaringBitmap;

public class ImmutableJsonIndexReader
implements JsonIndexReader {
    private final long _numDocs;
    private final int _version;
    private final StringDictionary _dictionary;
    private final BitmapInvertedIndexReader _invertedIndex;
    private final PinotDataBuffer _docIdMapping;

    public ImmutableJsonIndexReader(PinotDataBuffer dataBuffer, int numDocs) {
        this._numDocs = numDocs;
        this._version = dataBuffer.getInt(0);
        Preconditions.checkState((this._version == 1 || this._version == 2 ? 1 : 0) != 0, (String)"Unsupported json index version: %s", (int)this._version);
        int maxValueLength = dataBuffer.getInt(4);
        long dictionaryLength = dataBuffer.getLong(8);
        long invertedIndexLength = dataBuffer.getLong(16);
        long docIdMappingLength = dataBuffer.getLong(24);
        long dictionaryStartOffset = 32L;
        long dictionaryEndOffset = dictionaryStartOffset + dictionaryLength;
        this._dictionary = new StringDictionary(dataBuffer.view(dictionaryStartOffset, dictionaryEndOffset, ByteOrder.BIG_ENDIAN), 0, maxValueLength, 0);
        long invertedIndexEndOffset = dictionaryEndOffset + invertedIndexLength;
        this._invertedIndex = new BitmapInvertedIndexReader(dataBuffer.view(dictionaryEndOffset, invertedIndexEndOffset, ByteOrder.BIG_ENDIAN), this._dictionary.length());
        long docIdMappingEndOffset = invertedIndexEndOffset + docIdMappingLength;
        this._docIdMapping = dataBuffer.view(invertedIndexEndOffset, docIdMappingEndOffset, ByteOrder.LITTLE_ENDIAN);
    }

    public MutableRoaringBitmap getMatchingDocIds(String filterString) {
        FilterContext filter;
        try {
            filter = RequestContextUtils.getFilter((Expression)CalciteSqlParser.compileToExpression((String)filterString));
        }
        catch (Exception e) {
            throw new BadQueryRequestException("Invalid json match filter: " + filterString);
        }
        if (filter.getType() == FilterContext.Type.PREDICATE && this.isExclusive(filter.getPredicate().getType())) {
            MutableRoaringBitmap matchingFlattenedDocIds = this.getMatchingFlattenedDocIds(filter.getPredicate());
            MutableRoaringBitmap matchingDocIds = new MutableRoaringBitmap();
            matchingFlattenedDocIds.forEach(flattenedDocId -> matchingDocIds.add(this.getDocId(flattenedDocId)));
            matchingDocIds.flip(0L, this._numDocs);
            return matchingDocIds;
        }
        MutableRoaringBitmap matchingFlattenedDocIds = this.getMatchingFlattenedDocIds(filter);
        MutableRoaringBitmap matchingDocIds = new MutableRoaringBitmap();
        matchingFlattenedDocIds.forEach(flattenedDocId -> matchingDocIds.add(this.getDocId(flattenedDocId)));
        return matchingDocIds;
    }

    private boolean isExclusive(Predicate.Type predicateType) {
        return predicateType == Predicate.Type.NOT_EQ || predicateType == Predicate.Type.NOT_IN || predicateType == Predicate.Type.IS_NULL;
    }

    private MutableRoaringBitmap getMatchingFlattenedDocIds(FilterContext filter) {
        switch (filter.getType()) {
            case AND: {
                List children = filter.getChildren();
                int numChildren = children.size();
                MutableRoaringBitmap matchingDocIds = this.getMatchingFlattenedDocIds((FilterContext)children.get(0));
                for (int i = 1; i < numChildren; ++i) {
                    matchingDocIds.and((ImmutableRoaringBitmap)this.getMatchingFlattenedDocIds((FilterContext)children.get(i)));
                }
                return matchingDocIds;
            }
            case OR: {
                List children = filter.getChildren();
                int numChildren = children.size();
                MutableRoaringBitmap matchingDocIds = this.getMatchingFlattenedDocIds((FilterContext)children.get(0));
                for (int i = 1; i < numChildren; ++i) {
                    matchingDocIds.or((ImmutableRoaringBitmap)this.getMatchingFlattenedDocIds((FilterContext)children.get(i)));
                }
                return matchingDocIds;
            }
            case PREDICATE: {
                Predicate predicate = filter.getPredicate();
                Preconditions.checkArgument((!this.isExclusive(predicate.getType()) ? 1 : 0) != 0, (String)"Exclusive predicate: %s cannot be nested", (Object)predicate);
                return this.getMatchingFlattenedDocIds(predicate);
            }
        }
        throw new IllegalStateException();
    }

    private MutableRoaringBitmap getMatchingFlattenedDocIds(Predicate predicate) {
        Predicate.Type predicateType;
        ImmutableRoaringBitmap docIds;
        int dictId;
        String searchKey;
        String rightPart;
        String arrayIndex;
        String leftPart;
        int rightBracketIndex;
        int leftBracketIndex;
        ExpressionContext lhs = predicate.getLhs();
        Preconditions.checkArgument((lhs.getType() == ExpressionContext.Type.IDENTIFIER ? 1 : 0) != 0, (String)"Left-hand side of the predicate must be an identifier, got: %s (%s). Put double quotes around the identifier if needed.", (Object)lhs, (Object)lhs.getType());
        Object key = lhs.getIdentifier();
        MutableRoaringBitmap matchingDocIds = null;
        if (this._version == 2) {
            key = ((String)key).charAt(0) == '$' ? ((String)key).substring(1) : "." + (String)key;
            while ((leftBracketIndex = ((String)key).indexOf(91)) >= 0) {
                rightBracketIndex = ((String)key).indexOf(93, leftBracketIndex + 2);
                Preconditions.checkArgument((rightBracketIndex > 0 ? 1 : 0) != 0, (String)"Missing right bracket in key: %s", (Object)key);
                leftPart = ((String)key).substring(0, leftBracketIndex);
                arrayIndex = ((String)key).substring(leftBracketIndex + 1, rightBracketIndex);
                rightPart = ((String)key).substring(rightBracketIndex + 1);
                if (!arrayIndex.equals("*")) {
                    searchKey = leftPart + ".$index\u0000" + arrayIndex;
                    dictId = this._dictionary.indexOf(searchKey);
                    if (dictId >= 0) {
                        docIds = this._invertedIndex.getDocIds(dictId);
                        if (matchingDocIds == null) {
                            matchingDocIds = docIds.toMutableRoaringBitmap();
                        } else {
                            matchingDocIds.and(docIds);
                        }
                    } else {
                        return new MutableRoaringBitmap();
                    }
                }
                key = leftPart + "." + rightPart;
            }
        } else {
            if (((String)key).startsWith("$.")) {
                key = ((String)key).substring(2);
            }
            while ((leftBracketIndex = ((String)key).indexOf(91)) > 0) {
                rightBracketIndex = ((String)key).indexOf(93, leftBracketIndex + 2);
                Preconditions.checkArgument((rightBracketIndex > 0 ? 1 : 0) != 0, (String)"Missing right bracket in key: %s", (Object)key);
                leftPart = ((String)key).substring(0, leftBracketIndex);
                arrayIndex = ((String)key).substring(leftBracketIndex + 1, rightBracketIndex);
                rightPart = ((String)key).substring(rightBracketIndex + 1);
                if (!arrayIndex.equals("*")) {
                    searchKey = leftPart + ".$index\u0000" + arrayIndex;
                    dictId = this._dictionary.indexOf(searchKey);
                    if (dictId >= 0) {
                        docIds = this._invertedIndex.getDocIds(dictId);
                        if (matchingDocIds == null) {
                            matchingDocIds = docIds.toMutableRoaringBitmap();
                        } else {
                            matchingDocIds.and(docIds);
                        }
                    } else {
                        return new MutableRoaringBitmap();
                    }
                }
                key = leftPart + rightPart;
            }
        }
        if ((predicateType = predicate.getType()) == Predicate.Type.EQ || predicateType == Predicate.Type.NOT_EQ) {
            String value = predicateType == Predicate.Type.EQ ? ((EqPredicate)predicate).getValue() : ((NotEqPredicate)predicate).getValue();
            String keyValuePair = (String)key + "\u0000" + value;
            int dictId2 = this._dictionary.indexOf(keyValuePair);
            if (dictId2 >= 0) {
                ImmutableRoaringBitmap matchingDocIdsForKeyValuePair = this._invertedIndex.getDocIds(dictId2);
                if (matchingDocIds == null) {
                    matchingDocIds = matchingDocIdsForKeyValuePair.toMutableRoaringBitmap();
                } else {
                    matchingDocIds.and(matchingDocIdsForKeyValuePair);
                }
                return matchingDocIds;
            }
            return new MutableRoaringBitmap();
        }
        if (predicateType == Predicate.Type.IN || predicateType == Predicate.Type.NOT_IN) {
            List values = predicateType == Predicate.Type.IN ? ((InPredicate)predicate).getValues() : ((NotInPredicate)predicate).getValues();
            MutableRoaringBitmap matchingDocIdsForKeyValuePairs = new MutableRoaringBitmap();
            for (String value : values) {
                String keyValuePair = (String)key + "\u0000" + value;
                dictId = this._dictionary.indexOf(keyValuePair);
                if (dictId < 0) continue;
                matchingDocIdsForKeyValuePairs.or(this._invertedIndex.getDocIds(dictId));
            }
            if (matchingDocIds == null) {
                matchingDocIds = matchingDocIdsForKeyValuePairs;
            } else {
                matchingDocIds.and((ImmutableRoaringBitmap)matchingDocIdsForKeyValuePairs);
            }
            return matchingDocIds;
        }
        if (predicateType == Predicate.Type.IS_NOT_NULL || predicateType == Predicate.Type.IS_NULL) {
            int dictId3 = this._dictionary.indexOf((String)key);
            if (dictId3 >= 0) {
                ImmutableRoaringBitmap matchingDocIdsForKey = this._invertedIndex.getDocIds(dictId3);
                if (matchingDocIds == null) {
                    matchingDocIds = matchingDocIdsForKey.toMutableRoaringBitmap();
                } else {
                    matchingDocIds.and(matchingDocIdsForKey);
                }
                return matchingDocIds;
            }
            return new MutableRoaringBitmap();
        }
        throw new IllegalStateException("Unsupported json_match predicate type: " + predicate);
    }

    private int getDocId(int flattenedDocId) {
        return this._docIdMapping.getInt((long)flattenedDocId << 2);
    }

    public void close() {
    }
}

