/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.index.readers.forward;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.pinot.segment.spi.index.reader.ForwardIndexReaderContext;
import org.apache.pinot.segment.spi.memory.CleanerUtil;

public class ChunkReaderContext
implements ForwardIndexReaderContext {
    private final ByteBuffer _chunkBuffer;
    private int _chunkId;

    public ChunkReaderContext(int maxChunkSize) {
        this._chunkBuffer = ByteBuffer.allocateDirect(maxChunkSize);
        this._chunkId = -1;
    }

    public ByteBuffer getChunkBuffer() {
        return this._chunkBuffer;
    }

    public int getChunkId() {
        return this._chunkId;
    }

    public void setChunkId(int chunkId) {
        this._chunkId = chunkId;
    }

    public void close() throws IOException {
        if (CleanerUtil.UNMAP_SUPPORTED) {
            CleanerUtil.getCleaner().freeBuffer(this._chunkBuffer);
        }
    }
}

