/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.index.readers;

import java.math.BigDecimal;
import java.util.Arrays;
import org.apache.pinot.segment.local.segment.index.readers.BaseImmutableDictionary;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.utils.BigDecimalUtils;
import org.apache.pinot.spi.utils.ByteArray;
import org.apache.pinot.spi.utils.BytesUtils;

public class ConstantValueBytesDictionary
extends BaseImmutableDictionary {
    private final byte[] _value;

    public ConstantValueBytesDictionary(byte[] value) {
        super(1);
        this._value = value;
    }

    public FieldSpec.DataType getValueType() {
        return FieldSpec.DataType.BYTES;
    }

    @Override
    public int indexOf(String stringValue) {
        return Arrays.equals(BytesUtils.toBytes((String)stringValue), this._value) ? 0 : -1;
    }

    public int indexOf(ByteArray bytesValue) {
        return Arrays.equals(bytesValue.getBytes(), this._value) ? 0 : -1;
    }

    public int insertionIndexOf(String stringValue) {
        int result = ByteArray.compare((byte[])BytesUtils.toBytes((String)stringValue), (byte[])this._value);
        if (result < 0) {
            return -1;
        }
        if (result > 0) {
            return -2;
        }
        return 0;
    }

    public ByteArray getMinVal() {
        return new ByteArray(this._value);
    }

    public ByteArray getMaxVal() {
        return new ByteArray(this._value);
    }

    @Override
    public Object getSortedValues() {
        return new ByteArray[]{new ByteArray(this._value)};
    }

    public byte[] get(int dictId) {
        return this._value;
    }

    public Object getInternal(int dictId) {
        return new ByteArray(this._value);
    }

    public int getIntValue(int dictId) {
        throw new UnsupportedOperationException();
    }

    public long getLongValue(int dictId) {
        throw new UnsupportedOperationException();
    }

    public float getFloatValue(int dictId) {
        throw new UnsupportedOperationException();
    }

    public double getDoubleValue(int dictId) {
        throw new UnsupportedOperationException();
    }

    public BigDecimal getBigDecimalValue(int dictId) {
        return BigDecimalUtils.deserialize((byte[])this._value);
    }

    public String getStringValue(int dictId) {
        return BytesUtils.toHexString((byte[])this._value);
    }

    public byte[] getBytesValue(int dictId) {
        return this._value;
    }
}

