/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.index.datasource;

import java.util.Set;
import javax.annotation.Nullable;
import org.apache.pinot.segment.local.segment.index.datasource.BaseDataSource;
import org.apache.pinot.segment.spi.ColumnMetadata;
import org.apache.pinot.segment.spi.datasource.DataSourceMetadata;
import org.apache.pinot.segment.spi.index.column.ColumnIndexContainer;
import org.apache.pinot.segment.spi.partition.PartitionFunction;
import org.apache.pinot.spi.data.FieldSpec;

public class ImmutableDataSource
extends BaseDataSource {
    public ImmutableDataSource(ColumnMetadata columnMetadata, ColumnIndexContainer columnIndexContainer) {
        super(new ImmutableDataSourceMetadata(columnMetadata), columnIndexContainer.getForwardIndex(), columnIndexContainer.getDictionary(), columnIndexContainer.getInvertedIndex(), columnIndexContainer.getRangeIndex(), columnIndexContainer.getTextIndex(), columnIndexContainer.getFSTIndex(), columnIndexContainer.getJsonIndex(), columnIndexContainer.getH3Index(), columnIndexContainer.getBloomFilter(), columnIndexContainer.getNullValueVector());
    }

    private static class ImmutableDataSourceMetadata
    implements DataSourceMetadata {
        final FieldSpec _fieldSpec;
        final boolean _sorted;
        final int _numDocs;
        final int _numValues;
        final int _maxNumValuesPerMVEntry;
        final int _cardinality;
        final Comparable _minValue;
        final Comparable _maxValue;
        final PartitionFunction _partitionFunction;
        final Set<Integer> _partitions;

        ImmutableDataSourceMetadata(ColumnMetadata columnMetadata) {
            this._fieldSpec = columnMetadata.getFieldSpec();
            this._sorted = columnMetadata.isSorted();
            this._numDocs = columnMetadata.getTotalDocs();
            this._numValues = columnMetadata.getTotalNumberOfEntries();
            this._maxNumValuesPerMVEntry = this._fieldSpec.isSingleValueField() ? -1 : columnMetadata.getMaxNumberOfMultiValues();
            this._minValue = columnMetadata.getMinValue();
            this._maxValue = columnMetadata.getMaxValue();
            this._partitionFunction = columnMetadata.getPartitionFunction();
            this._partitions = columnMetadata.getPartitions();
            this._cardinality = columnMetadata.getCardinality();
        }

        public FieldSpec getFieldSpec() {
            return this._fieldSpec;
        }

        public boolean isSorted() {
            return this._sorted;
        }

        public int getNumDocs() {
            return this._numDocs;
        }

        public int getNumValues() {
            return this._numValues;
        }

        public int getMaxNumValuesPerMVEntry() {
            return this._maxNumValuesPerMVEntry;
        }

        @Nullable
        public Comparable getMinValue() {
            return this._minValue;
        }

        @Nullable
        public Comparable getMaxValue() {
            return this._maxValue;
        }

        @Nullable
        public PartitionFunction getPartitionFunction() {
            return this._partitionFunction;
        }

        @Nullable
        public Set<Integer> getPartitions() {
            return this._partitions;
        }

        public int getCardinality() {
            return this._cardinality;
        }
    }
}

