/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.index.column;

import java.io.Closeable;
import java.io.IOException;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.pinot.segment.local.segment.index.column.NumValuesInfo;
import org.apache.pinot.segment.local.segment.index.datasource.MutableDataSource;
import org.apache.pinot.segment.spi.datasource.DataSource;
import org.apache.pinot.segment.spi.index.mutable.MutableDictionary;
import org.apache.pinot.segment.spi.index.mutable.MutableForwardIndex;
import org.apache.pinot.segment.spi.index.reader.Dictionary;
import org.apache.pinot.segment.spi.index.reader.ForwardIndexReader;
import org.apache.pinot.segment.spi.partition.PartitionFunction;
import org.apache.pinot.spi.data.FieldSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IntermediateIndexContainer
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(IntermediateIndexContainer.class);
    final FieldSpec _fieldSpec;
    final PartitionFunction _partitionFunction;
    final Set<Integer> _partitions;
    final NumValuesInfo _numValuesInfo;
    final MutableForwardIndex _forwardIndex;
    final MutableDictionary _dictionary;
    volatile Comparable _minValue;
    volatile Comparable _maxValue;
    int _dictId = Integer.MIN_VALUE;
    int[] _dictIds;

    public IntermediateIndexContainer(FieldSpec fieldSpec, @Nullable PartitionFunction partitionFunction, @Nullable Set<Integer> partitions, NumValuesInfo numValuesInfo, MutableForwardIndex forwardIndex, MutableDictionary dictionary) {
        this._fieldSpec = fieldSpec;
        this._partitionFunction = partitionFunction;
        this._partitions = partitions;
        this._numValuesInfo = numValuesInfo;
        this._forwardIndex = forwardIndex;
        this._dictionary = dictionary;
    }

    public DataSource toDataSource(int numDocsIndexed) {
        return new MutableDataSource(this._fieldSpec, numDocsIndexed, this._numValuesInfo._numValues, this._numValuesInfo._maxNumValuesPerMVEntry, this._dictionary.length(), this._partitionFunction, this._partitions, this._minValue, this._maxValue, (ForwardIndexReader)this._forwardIndex, (Dictionary)this._dictionary, null, null, null, null, null, null, null, null);
    }

    @Override
    public void close() throws IOException {
        String column = this._fieldSpec.getName();
        try {
            this._forwardIndex.close();
        }
        catch (Exception e) {
            LOGGER.error("Caught exception while closing forward index for column: {}, continuing with error", (Object)column, (Object)e);
        }
        if (this._dictionary != null) {
            try {
                this._dictionary.close();
            }
            catch (Exception e) {
                LOGGER.error("Caught exception while closing dictionary for column: {}, continuing with error", (Object)column, (Object)e);
            }
        }
    }

    public FieldSpec getFieldSpec() {
        return this._fieldSpec;
    }

    public NumValuesInfo getNumValuesInfo() {
        return this._numValuesInfo;
    }

    public MutableForwardIndex getForwardIndex() {
        return this._forwardIndex;
    }

    public MutableDictionary getDictionary() {
        return this._dictionary;
    }

    public int getDictId() {
        return this._dictId;
    }

    public void setDictId(int dictId) {
        this._dictId = dictId;
    }

    public int[] getDictIds() {
        return this._dictIds;
    }

    public void setDictIds(int[] dictIds) {
        this._dictIds = dictIds;
    }

    public Comparable getMinValue() {
        return this._minValue;
    }

    public void setMinValue(Comparable minValue) {
        this._minValue = minValue;
    }

    public Comparable getMaxValue() {
        return this._maxValue;
    }

    public void setMaxValue(Comparable maxValue) {
        this._maxValue = maxValue;
    }
}

