/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.creator.impl.stats;

import java.util.HashMap;
import java.util.Map;
import org.apache.pinot.segment.local.segment.creator.impl.stats.AbstractColumnStatisticsCollector;
import org.apache.pinot.segment.local.segment.creator.impl.stats.BigDecimalColumnPreIndexStatsCollector;
import org.apache.pinot.segment.local.segment.creator.impl.stats.BytesColumnPredIndexStatsCollector;
import org.apache.pinot.segment.local.segment.creator.impl.stats.DoubleColumnPreIndexStatsCollector;
import org.apache.pinot.segment.local.segment.creator.impl.stats.FloatColumnPreIndexStatsCollector;
import org.apache.pinot.segment.local.segment.creator.impl.stats.IntColumnPreIndexStatsCollector;
import org.apache.pinot.segment.local.segment.creator.impl.stats.LongColumnPreIndexStatsCollector;
import org.apache.pinot.segment.local.segment.creator.impl.stats.StringColumnPreIndexStatsCollector;
import org.apache.pinot.segment.spi.creator.ColumnStatistics;
import org.apache.pinot.segment.spi.creator.SegmentPreIndexStatsCollector;
import org.apache.pinot.segment.spi.creator.StatsCollectorConfig;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.data.readers.GenericRow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentPreIndexStatsCollectorImpl
implements SegmentPreIndexStatsCollector {
    private static final Logger LOGGER = LoggerFactory.getLogger(SegmentPreIndexStatsCollectorImpl.class);
    private final StatsCollectorConfig _statsCollectorConfig;
    private Map<String, AbstractColumnStatisticsCollector> _columnStatsCollectorMap;
    private int _totalDocCount;

    public SegmentPreIndexStatsCollectorImpl(StatsCollectorConfig statsCollectorConfig) {
        this._statsCollectorConfig = statsCollectorConfig;
    }

    public void init() {
        this._columnStatsCollectorMap = new HashMap<String, AbstractColumnStatisticsCollector>();
        Schema dataSchema = this._statsCollectorConfig.getSchema();
        block9: for (FieldSpec fieldSpec : dataSchema.getAllFieldSpecs()) {
            String column = fieldSpec.getName();
            switch (fieldSpec.getDataType().getStoredType()) {
                case INT: {
                    this._columnStatsCollectorMap.put(column, new IntColumnPreIndexStatsCollector(column, this._statsCollectorConfig));
                    continue block9;
                }
                case LONG: {
                    this._columnStatsCollectorMap.put(column, new LongColumnPreIndexStatsCollector(column, this._statsCollectorConfig));
                    continue block9;
                }
                case FLOAT: {
                    this._columnStatsCollectorMap.put(column, new FloatColumnPreIndexStatsCollector(column, this._statsCollectorConfig));
                    continue block9;
                }
                case DOUBLE: {
                    this._columnStatsCollectorMap.put(column, new DoubleColumnPreIndexStatsCollector(column, this._statsCollectorConfig));
                    continue block9;
                }
                case BIG_DECIMAL: {
                    this._columnStatsCollectorMap.put(column, new BigDecimalColumnPreIndexStatsCollector(column, this._statsCollectorConfig));
                    continue block9;
                }
                case STRING: {
                    this._columnStatsCollectorMap.put(column, new StringColumnPreIndexStatsCollector(column, this._statsCollectorConfig));
                    continue block9;
                }
                case BYTES: {
                    this._columnStatsCollectorMap.put(column, new BytesColumnPredIndexStatsCollector(column, this._statsCollectorConfig));
                    continue block9;
                }
            }
            throw new IllegalStateException("Unsupported data type: " + fieldSpec.getDataType());
        }
    }

    public void build() {
        for (AbstractColumnStatisticsCollector columnStatsCollector : this._columnStatsCollectorMap.values()) {
            columnStatsCollector.seal();
        }
    }

    public ColumnStatistics getColumnProfileFor(String column) {
        return this._columnStatsCollectorMap.get(column);
    }

    public void collectRow(GenericRow row) {
        for (Map.Entry columnNameAndValue : row.getFieldToValueMap().entrySet()) {
            String columnName = (String)columnNameAndValue.getKey();
            Object value = columnNameAndValue.getValue();
            if (!this._columnStatsCollectorMap.containsKey(columnName)) continue;
            try {
                this._columnStatsCollectorMap.get(columnName).collect(value);
            }
            catch (Exception e) {
                LOGGER.error("Exception while collecting stats for column:{} in row:{}", (Object)columnName, (Object)row);
                throw e;
            }
        }
        ++this._totalDocCount;
    }

    public int getTotalDocCount() {
        return this._totalDocCount;
    }

    public void logStats() {
        try {
            for (String column : this._columnStatsCollectorMap.keySet()) {
                AbstractColumnStatisticsCollector statisticsCollector = this._columnStatsCollectorMap.get(column);
                LOGGER.info("********** logging for column : " + column + " ********************* ");
                LOGGER.info("min value : " + statisticsCollector.getMinValue());
                LOGGER.info("max value : " + statisticsCollector.getMaxValue());
                LOGGER.info("cardinality : " + statisticsCollector.getCardinality());
                LOGGER.info("length of largest column : " + statisticsCollector.getLengthOfLargestElement());
                LOGGER.info("is sorted : " + statisticsCollector.isSorted());
                LOGGER.info("column type : " + this._statsCollectorConfig.getSchema().getFieldSpecFor(column).getDataType());
                if (statisticsCollector.getPartitionFunction() != null) {
                    LOGGER.info("partitions: " + statisticsCollector.getPartitions().toString());
                }
                LOGGER.info("***********************************************");
            }
        }
        catch (Exception e) {
            LOGGER.error("Caught exception while logging column stats", (Throwable)e);
        }
    }
}

