/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.creator.impl.stats;

import it.unimi.dsi.fastutil.floats.FloatOpenHashSet;
import it.unimi.dsi.fastutil.floats.FloatSet;
import java.util.Arrays;
import org.apache.pinot.segment.local.segment.creator.impl.stats.AbstractColumnStatisticsCollector;
import org.apache.pinot.segment.spi.creator.StatsCollectorConfig;

public class FloatColumnPreIndexStatsCollector
extends AbstractColumnStatisticsCollector {
    private FloatSet _values = new FloatOpenHashSet(1000);
    private float[] _sortedValues;
    private boolean _sealed = false;
    private float _prevValue = Float.NEGATIVE_INFINITY;

    public FloatColumnPreIndexStatsCollector(String column, StatsCollectorConfig statsCollectorConfig) {
        super(column, statsCollectorConfig);
    }

    @Override
    public void collect(Object entry) {
        assert (!this._sealed);
        if (entry instanceof Object[]) {
            Object[] values;
            for (Object obj : values = (Object[])entry) {
                float value = ((Float)obj).floatValue();
                this._values.add(value);
            }
            this._maxNumberOfMultiValues = Math.max(this._maxNumberOfMultiValues, values.length);
            this.updateTotalNumberOfEntries(values);
        } else {
            float value = ((Float)entry).floatValue();
            this.addressSorted(value);
            if (this._values.add(value)) {
                this.updatePartition(Float.valueOf(value));
            }
            ++this._totalNumberOfEntries;
        }
    }

    private void addressSorted(float entry) {
        if (this._sorted) {
            this._sorted = entry >= this._prevValue;
            this._prevValue = entry;
        }
    }

    public Float getMinValue() {
        if (this._sealed) {
            return Float.valueOf(this._sortedValues[0]);
        }
        throw new IllegalStateException("you must seal the collector first before asking for min value");
    }

    public Float getMaxValue() {
        if (this._sealed) {
            return Float.valueOf(this._sortedValues[this._sortedValues.length - 1]);
        }
        throw new IllegalStateException("you must seal the collector first before asking for max value");
    }

    public Object getUniqueValuesSet() {
        if (this._sealed) {
            return this._sortedValues;
        }
        throw new IllegalStateException("you must seal the collector first before asking for unique values set");
    }

    public int getCardinality() {
        if (this._sealed) {
            return this._sortedValues.length;
        }
        throw new IllegalStateException("you must seal the collector first before asking for cardinality");
    }

    @Override
    public void seal() {
        if (!this._sealed) {
            this._sortedValues = this._values.toFloatArray();
            this._values = null;
            Arrays.sort(this._sortedValues);
            this._sealed = true;
        }
    }
}

