/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.creator.impl.inv.geospatial;

import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongList;
import java.io.BufferedOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.PriorityQueue;
import org.apache.pinot.segment.local.segment.creator.impl.inv.geospatial.BaseH3IndexCreator;
import org.apache.pinot.segment.spi.index.reader.H3IndexResolution;
import org.apache.pinot.segment.spi.memory.PinotDataBuffer;
import org.locationtech.jts.geom.Geometry;
import org.roaringbitmap.BitmapDataProvider;
import org.roaringbitmap.RoaringBitmap;
import org.roaringbitmap.RoaringBitmapWriter;
import org.roaringbitmap.buffer.ImmutableRoaringBitmap;
import org.roaringbitmap.buffer.MutableRoaringBitmap;

public class OffHeapH3IndexCreator
extends BaseH3IndexCreator {
    private static final int FLUSH_THRESHOLD = 100000;
    private static final String POSTING_LIST_FILE_NAME = "posting.buf";
    private final File _postingListFile;
    private final DataOutputStream _postingListOutputStream;
    private final LongList _postingListChunkEndOffsets = new LongArrayList();
    private long _postingListChunkOffset;

    public OffHeapH3IndexCreator(File indexDir, String columnName, H3IndexResolution resolution) throws IOException {
        super(indexDir, columnName, resolution);
        this._postingListFile = new File(this._tempDir, POSTING_LIST_FILE_NAME);
        this._postingListOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this._postingListFile)));
    }

    @Override
    public void add(Geometry geometry) throws IOException {
        super.add(geometry);
        if (this._postingListMap.size() % 100000 == 0) {
            this.flush();
        }
    }

    private void flush() throws IOException {
        long length = 0L;
        for (Map.Entry entry : this._postingListMap.entrySet()) {
            this._postingListOutputStream.writeLong((Long)entry.getKey());
            length += 8L;
            RoaringBitmap docIds = (RoaringBitmap)((RoaringBitmapWriter)entry.getValue()).get();
            int bitmapSize = docIds.serializedSizeInBytes();
            this._postingListOutputStream.writeInt(bitmapSize);
            docIds.serialize((DataOutput)this._postingListOutputStream);
            length += (long)(4 + bitmapSize);
        }
        this._postingListChunkOffset += length;
        this._postingListChunkEndOffsets.add(this._postingListChunkOffset);
        this._postingListMap.clear();
    }

    public void seal() throws IOException {
        if (this._postingListChunkEndOffsets.isEmpty()) {
            this._postingListOutputStream.close();
            for (Map.Entry entry : this._postingListMap.entrySet()) {
                this.add((Long)entry.getKey(), ((RoaringBitmapWriter)entry.getValue()).get());
            }
            this.generateIndexFile();
            return;
        }
        if (this._postingListMap.size() % 100000 != 0) {
            this.flush();
        }
        this._postingListOutputStream.close();
        try (PinotDataBuffer postingListBuffer = PinotDataBuffer.mapFile((File)this._postingListFile, (boolean)true, (long)0L, (long)this._postingListFile.length(), (ByteOrder)ByteOrder.BIG_ENDIAN, (String)"H3 index posting list");){
            int numChunks = this._postingListChunkEndOffsets.size();
            ArrayList<ChunkIterator> chunkIterators = new ArrayList<ChunkIterator>(numChunks);
            long chunkEndOffset = 0L;
            for (int i = 0; i < numChunks; ++i) {
                long chunkStartOffset = chunkEndOffset;
                chunkEndOffset = this._postingListChunkEndOffsets.getLong(i);
                PinotDataBuffer chunkDataBuffer = postingListBuffer.view(chunkStartOffset, chunkEndOffset);
                chunkIterators.add(new ChunkIterator(chunkDataBuffer, i));
            }
            PriorityQueue<PostingListEntry> priorityQueue = new PriorityQueue<PostingListEntry>(numChunks);
            for (ChunkIterator chunkIterator : chunkIterators) {
                priorityQueue.offer(chunkIterator.next());
            }
            long currentH3Id = Long.MIN_VALUE;
            MutableRoaringBitmap currentDocIds = null;
            while (!priorityQueue.isEmpty()) {
                ChunkIterator chunkIterator;
                PostingListEntry leastEntry = (PostingListEntry)priorityQueue.poll();
                if (currentH3Id == Long.MIN_VALUE || currentH3Id != leastEntry._h3Id) {
                    if (currentH3Id != Long.MIN_VALUE) {
                        this.add(currentH3Id, (BitmapDataProvider)currentDocIds);
                    }
                    currentH3Id = leastEntry._h3Id;
                    currentDocIds = leastEntry._docIds.toMutableRoaringBitmap();
                } else {
                    currentDocIds.or(leastEntry._docIds);
                }
                if (!(chunkIterator = (ChunkIterator)chunkIterators.get(leastEntry._chunkId)).hasNext()) continue;
                priorityQueue.offer(chunkIterator.next());
            }
            assert (currentDocIds != null);
            this.add(currentH3Id, (BitmapDataProvider)currentDocIds);
            this.generateIndexFile();
        }
    }

    @Override
    public void close() throws IOException {
        this._postingListOutputStream.close();
        super.close();
    }

    private static class PostingListEntry
    implements Comparable<PostingListEntry> {
        final long _h3Id;
        final ImmutableRoaringBitmap _docIds;
        final int _chunkId;

        private PostingListEntry(long h3Id, ImmutableRoaringBitmap docIds, int chunkId) {
            this._h3Id = h3Id;
            this._docIds = docIds;
            this._chunkId = chunkId;
        }

        @Override
        public int compareTo(PostingListEntry entry) {
            return Long.compare(this._h3Id, entry._h3Id);
        }
    }

    private static class ChunkIterator
    implements Iterator<PostingListEntry> {
        final PinotDataBuffer _dataBuffer;
        final long _bufferSize;
        final int _chunkId;
        long _offset;

        ChunkIterator(PinotDataBuffer dataBuffer, int chunkId) {
            this._dataBuffer = dataBuffer;
            this._bufferSize = dataBuffer.size();
            this._chunkId = chunkId;
        }

        @Override
        public boolean hasNext() {
            return this._offset < this._bufferSize;
        }

        @Override
        public PostingListEntry next() {
            long h3Id = this._dataBuffer.getLong(this._offset);
            this._offset += 8L;
            int bitmapSize = this._dataBuffer.getInt(this._offset);
            this._offset += 4L;
            ImmutableRoaringBitmap docIds = new ImmutableRoaringBitmap(this._dataBuffer.toDirectByteBuffer(this._offset, bitmapSize));
            this._offset += (long)bitmapSize;
            return new PostingListEntry(h3Id, docIds, this._chunkId);
        }
    }
}

