/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.creator.impl;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.apache.pinot.segment.local.segment.creator.impl.bloom.OnHeapGuavaBloomFilterCreator;
import org.apache.pinot.segment.local.segment.creator.impl.fwd.MultiValueFixedByteRawIndexCreator;
import org.apache.pinot.segment.local.segment.creator.impl.fwd.MultiValueUnsortedForwardIndexCreator;
import org.apache.pinot.segment.local.segment.creator.impl.fwd.MultiValueVarByteRawIndexCreator;
import org.apache.pinot.segment.local.segment.creator.impl.fwd.NoOpForwardIndexCreator;
import org.apache.pinot.segment.local.segment.creator.impl.fwd.SingleValueFixedByteRawIndexCreator;
import org.apache.pinot.segment.local.segment.creator.impl.fwd.SingleValueSortedForwardIndexCreator;
import org.apache.pinot.segment.local.segment.creator.impl.fwd.SingleValueUnsortedForwardIndexCreator;
import org.apache.pinot.segment.local.segment.creator.impl.fwd.SingleValueVarByteRawIndexCreator;
import org.apache.pinot.segment.local.segment.creator.impl.inv.BitSlicedRangeIndexCreator;
import org.apache.pinot.segment.local.segment.creator.impl.inv.OffHeapBitmapInvertedIndexCreator;
import org.apache.pinot.segment.local.segment.creator.impl.inv.OnHeapBitmapInvertedIndexCreator;
import org.apache.pinot.segment.local.segment.creator.impl.inv.RangeIndexCreator;
import org.apache.pinot.segment.local.segment.creator.impl.inv.geospatial.OffHeapH3IndexCreator;
import org.apache.pinot.segment.local.segment.creator.impl.inv.geospatial.OnHeapH3IndexCreator;
import org.apache.pinot.segment.local.segment.creator.impl.inv.json.OffHeapJsonIndexCreator;
import org.apache.pinot.segment.local.segment.creator.impl.inv.json.OnHeapJsonIndexCreator;
import org.apache.pinot.segment.local.segment.creator.impl.inv.text.LuceneFSTIndexCreator;
import org.apache.pinot.segment.local.segment.creator.impl.text.LuceneTextIndexCreator;
import org.apache.pinot.segment.local.segment.creator.impl.text.NativeTextIndexCreator;
import org.apache.pinot.segment.local.utils.nativefst.NativeFSTIndexCreator;
import org.apache.pinot.segment.spi.compression.ChunkCompressionType;
import org.apache.pinot.segment.spi.creator.IndexCreationContext;
import org.apache.pinot.segment.spi.creator.IndexCreatorProvider;
import org.apache.pinot.segment.spi.index.creator.BloomFilterCreator;
import org.apache.pinot.segment.spi.index.creator.CombinedInvertedIndexCreator;
import org.apache.pinot.segment.spi.index.creator.DictionaryBasedInvertedIndexCreator;
import org.apache.pinot.segment.spi.index.creator.ForwardIndexCreator;
import org.apache.pinot.segment.spi.index.creator.GeoSpatialIndexCreator;
import org.apache.pinot.segment.spi.index.creator.JsonIndexCreator;
import org.apache.pinot.segment.spi.index.creator.TextIndexCreator;
import org.apache.pinot.segment.spi.index.reader.H3IndexResolution;
import org.apache.pinot.spi.config.table.FSTType;
import org.apache.pinot.spi.data.FieldSpec;

public final class DefaultIndexCreatorProvider
implements IndexCreatorProvider {
    public ForwardIndexCreator newForwardIndexCreator(IndexCreationContext.Forward context) throws Exception {
        if (!context.hasDictionary()) {
            boolean deriveNumDocsPerChunk = DefaultIndexCreatorProvider.shouldDeriveNumDocsPerChunk(context.getFieldSpec().getName(), context.getColumnProperties());
            int writerVersion = DefaultIndexCreatorProvider.getRawIndexWriterVersion(context.getFieldSpec().getName(), context.getColumnProperties());
            if (context.getFieldSpec().isSingleValueField()) {
                return DefaultIndexCreatorProvider.getRawIndexCreatorForSVColumn(context.getIndexDir(), context.getChunkCompressionType(), context.getFieldSpec().getName(), context.getFieldSpec().getDataType().getStoredType(), context.getTotalDocs(), context.getLengthOfLongestEntry(), deriveNumDocsPerChunk, writerVersion);
            }
            return DefaultIndexCreatorProvider.getRawIndexCreatorForMVColumn(context.getIndexDir(), context.getChunkCompressionType(), context.getFieldSpec().getName(), context.getFieldSpec().getDataType().getStoredType(), context.getTotalDocs(), context.getMaxNumberOfMultiValueElements(), deriveNumDocsPerChunk, writerVersion, context.getMaxRowLengthInBytes());
        }
        if (context.forwardIndexDisabled() && !context.isSorted()) {
            return new NoOpForwardIndexCreator(context.getFieldSpec().isSingleValueField());
        }
        if (context.getFieldSpec().isSingleValueField()) {
            if (context.isSorted()) {
                return new SingleValueSortedForwardIndexCreator(context.getIndexDir(), context.getFieldSpec().getName(), context.getCardinality());
            }
            return new SingleValueUnsortedForwardIndexCreator(context.getIndexDir(), context.getFieldSpec().getName(), context.getCardinality(), context.getTotalDocs());
        }
        return new MultiValueUnsortedForwardIndexCreator(context.getIndexDir(), context.getFieldSpec().getName(), context.getCardinality(), context.getTotalDocs(), context.getTotalNumberOfEntries());
    }

    public DictionaryBasedInvertedIndexCreator newInvertedIndexCreator(IndexCreationContext.Inverted context) throws IOException {
        if (context.isOnHeap()) {
            return new OnHeapBitmapInvertedIndexCreator(context.getIndexDir(), context.getFieldSpec().getName(), context.getCardinality());
        }
        return new OffHeapBitmapInvertedIndexCreator(context.getIndexDir(), context.getFieldSpec(), context.getCardinality(), context.getTotalDocs(), context.getTotalNumberOfEntries());
    }

    public JsonIndexCreator newJsonIndexCreator(IndexCreationContext.Json context) throws IOException {
        Preconditions.checkState((boolean)context.getFieldSpec().isSingleValueField(), (Object)"Json index is currently only supported on single-value columns");
        Preconditions.checkState((context.getFieldSpec().getDataType().getStoredType() == FieldSpec.DataType.STRING ? 1 : 0) != 0, (Object)"Json index is currently only supported on STRING columns");
        return context.isOnHeap() ? new OnHeapJsonIndexCreator(context.getIndexDir(), context.getFieldSpec().getName(), context.getJsonIndexConfig()) : new OffHeapJsonIndexCreator(context.getIndexDir(), context.getFieldSpec().getName(), context.getJsonIndexConfig());
    }

    public TextIndexCreator newTextIndexCreator(IndexCreationContext.Text context) throws IOException {
        if (context.isFst()) {
            Preconditions.checkState((boolean)context.getFieldSpec().isSingleValueField(), (Object)"FST index is currently only supported on single-value columns");
            Preconditions.checkState((context.getFieldSpec().getDataType().getStoredType() == FieldSpec.DataType.STRING ? 1 : 0) != 0, (Object)"FST index is currently only supported on STRING type columns");
            Preconditions.checkState((boolean)context.hasDictionary(), (Object)"FST index is currently only supported on dictionary-encoded columns");
            String[] sortedValues = context.getSortedUniqueElementsArray();
            if (context.getFstType() == FSTType.NATIVE) {
                return new NativeFSTIndexCreator(context.getIndexDir(), context.getFieldSpec().getName(), sortedValues);
            }
            return new LuceneFSTIndexCreator(context.getIndexDir(), context.getFieldSpec().getName(), sortedValues);
        }
        Preconditions.checkState((context.getFieldSpec().getDataType().getStoredType() == FieldSpec.DataType.STRING ? 1 : 0) != 0, (Object)"Text index is currently only supported on STRING type columns");
        if (context.getFstType() == FSTType.NATIVE) {
            return new NativeTextIndexCreator(context.getFieldSpec().getName(), context.getIndexDir());
        }
        return new LuceneTextIndexCreator(context.getFieldSpec().getName(), context.getIndexDir(), context.isCommitOnClose(), context.getStopWordsInclude(), context.getStopWordsExclude());
    }

    public GeoSpatialIndexCreator newGeoSpatialIndexCreator(IndexCreationContext.Geospatial context) throws IOException {
        Preconditions.checkState((boolean)context.getFieldSpec().isSingleValueField(), (Object)"H3 index is currently only supported on single-value columns");
        Preconditions.checkState((context.getFieldSpec().getDataType().getStoredType() == FieldSpec.DataType.BYTES ? 1 : 0) != 0, (Object)"H3 index is currently only supported on BYTES columns");
        H3IndexResolution resolution = Objects.requireNonNull(context.getH3IndexConfig()).getResolution();
        return context.isOnHeap() ? new OnHeapH3IndexCreator(context.getIndexDir(), context.getFieldSpec().getName(), resolution) : new OffHeapH3IndexCreator(context.getIndexDir(), context.getFieldSpec().getName(), resolution);
    }

    public static boolean shouldDeriveNumDocsPerChunk(String columnName, Map<String, Map<String, String>> columnProperties) {
        if (columnProperties != null) {
            Map<String, String> properties = columnProperties.get(columnName);
            return properties != null && Boolean.parseBoolean(properties.get("deriveNumDocsPerChunkForRawIndex"));
        }
        return false;
    }

    public static int getRawIndexWriterVersion(String columnName, Map<String, Map<String, String>> columnProperties) {
        if (columnProperties != null && columnProperties.get(columnName) != null) {
            Map<String, String> properties = columnProperties.get(columnName);
            String version = properties.get("rawIndexWriterVersion");
            if (version == null) {
                return 2;
            }
            return Integer.parseInt(version);
        }
        return 2;
    }

    public static ForwardIndexCreator getRawIndexCreatorForSVColumn(File file, ChunkCompressionType compressionType, String column, FieldSpec.DataType dataType, int totalDocs, int lengthOfLongestEntry, boolean deriveNumDocsPerChunk, int writerVersion) throws IOException {
        switch (dataType.getStoredType()) {
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: {
                return new SingleValueFixedByteRawIndexCreator(file, compressionType, column, totalDocs, dataType, writerVersion);
            }
            case BIG_DECIMAL: 
            case STRING: 
            case BYTES: {
                return new SingleValueVarByteRawIndexCreator(file, compressionType, column, totalDocs, dataType, lengthOfLongestEntry, deriveNumDocsPerChunk, writerVersion);
            }
        }
        throw new UnsupportedOperationException("Data type not supported for raw indexing: " + dataType);
    }

    public static ForwardIndexCreator getRawIndexCreatorForMVColumn(File file, ChunkCompressionType compressionType, String column, FieldSpec.DataType dataType, int totalDocs, int maxNumberOfMultiValueElements, boolean deriveNumDocsPerChunk, int writerVersion, int maxRowLengthInBytes) throws IOException {
        switch (dataType.getStoredType()) {
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: {
                return new MultiValueFixedByteRawIndexCreator(file, compressionType, column, totalDocs, dataType, maxNumberOfMultiValueElements, deriveNumDocsPerChunk, writerVersion);
            }
            case STRING: 
            case BYTES: {
                return new MultiValueVarByteRawIndexCreator(file, compressionType, column, totalDocs, dataType, writerVersion, maxRowLengthInBytes, maxNumberOfMultiValueElements);
            }
        }
        throw new UnsupportedOperationException("Data type not supported for raw indexing: " + dataType);
    }

    public BloomFilterCreator newBloomFilterCreator(IndexCreationContext.BloomFilter context) throws IOException {
        int cardinality = context.getCardinality();
        if (cardinality == Integer.MIN_VALUE) {
            cardinality = context.getTotalNumberOfEntries();
        }
        return new OnHeapGuavaBloomFilterCreator(context.getIndexDir(), context.getFieldSpec().getName(), cardinality, Objects.requireNonNull(context.getBloomFilterConfig()));
    }

    public CombinedInvertedIndexCreator newRangeIndexCreator(IndexCreationContext.Range context) throws IOException {
        if (context.getRangeIndexVersion() == 2 && context.getFieldSpec().isSingleValueField()) {
            if (context.hasDictionary()) {
                return new BitSlicedRangeIndexCreator(context.getIndexDir(), context.getFieldSpec(), context.getCardinality());
            }
            return new BitSlicedRangeIndexCreator(context.getIndexDir(), context.getFieldSpec(), context.getMinValue(), context.getMaxValue());
        }
        return new RangeIndexCreator(context.getIndexDir(), context.getFieldSpec(), context.hasDictionary() ? FieldSpec.DataType.INT : context.getFieldSpec().getDataType(), -1, -1, context.getTotalDocs(), context.getTotalNumberOfEntries());
    }
}

