/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.realtime.impl.dictionary;

import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicReferenceArray;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.pinot.segment.spi.memory.PinotDataBuffer;
import org.apache.pinot.segment.spi.memory.PinotDataBufferMemoryManager;

@ThreadSafe
public class OffHeapMutableBytesStore
implements Closeable {
    private static final byte[] EMPTY_BYTES = new byte[0];
    private static final int OFFSET_BUFFER_SHIFT_OFFSET = 13;
    private static final int OFFSET_BUFFER_SIZE = 32772;
    private static final int OFFSET_BUFFER_MASK = 8191;
    private static final int VALUE_BUFFER_SHIFT_OFFSET = 20;
    private static final int VALUE_BUFFER_SIZE = 0x100000;
    private static final int VALUE_BUFFER_MASK = 1048575;
    private static final int MAX_NUM_BUFFERS = 2048;
    private final AtomicReferenceArray<PinotDataBuffer> _offsetBuffers = new AtomicReferenceArray(2048);
    private final AtomicReferenceArray<PinotDataBuffer> _valueBuffers = new AtomicReferenceArray(2048);
    private final PinotDataBufferMemoryManager _memoryManager;
    private final String _allocationContext;
    private int _previousValueEndOffset;
    private transient int _numValues;
    private transient int _totalBufferSize;

    public OffHeapMutableBytesStore(PinotDataBufferMemoryManager memoryManager, String allocationContext) {
        this._memoryManager = memoryManager;
        this._allocationContext = allocationContext;
    }

    public int add(byte[] value) {
        int valueStartOffset;
        PinotDataBuffer valueBuffer;
        PinotDataBuffer offsetBuffer;
        int offsetBufferIndex = this._numValues >>> 13;
        int offsetIndex = this._numValues & 0x1FFF;
        if (offsetIndex == 0) {
            offsetBuffer = this._memoryManager.allocate(32772L, this._allocationContext);
            offsetBuffer.putInt(0, this._previousValueEndOffset);
            this._offsetBuffers.set(offsetBufferIndex, offsetBuffer);
            this._totalBufferSize += 32772;
        } else {
            offsetBuffer = this._offsetBuffers.get(offsetBufferIndex);
        }
        int valueLength = value.length;
        if (valueLength == 0) {
            offsetBuffer.putInt(offsetIndex + 1 << 2, this._previousValueEndOffset);
            return this._numValues++;
        }
        int valueBufferIndex = this._previousValueEndOffset + valueLength - 1 >>> 20;
        if (this._previousValueEndOffset - 1 >>> 20 != valueBufferIndex) {
            valueBuffer = this._memoryManager.allocate(0x100000L, this._allocationContext);
            this._valueBuffers.set(valueBufferIndex, valueBuffer);
            this._totalBufferSize += 0x100000;
            valueStartOffset = valueBufferIndex << 20;
        } else {
            valueBuffer = this._valueBuffers.get(valueBufferIndex);
            valueStartOffset = this._previousValueEndOffset;
        }
        int valueEndOffset = valueStartOffset + valueLength;
        offsetBuffer.putInt(offsetIndex + 1 << 2, valueEndOffset);
        valueBuffer.readFrom((long)(valueStartOffset & 0xFFFFF), value);
        this._previousValueEndOffset = valueEndOffset;
        return this._numValues++;
    }

    public byte[] get(int index) {
        int valueLength;
        int startOffsetInValueBuffer;
        int valueEndOffset;
        int offsetIndex;
        assert (index < this._numValues);
        int offsetBufferIndex = index >>> 13;
        PinotDataBuffer offsetBuffer = this._offsetBuffers.get(offsetBufferIndex);
        int previousValueEndOffset = offsetBuffer.getInt((offsetIndex = index & 0x1FFF) << 2);
        if (previousValueEndOffset == (valueEndOffset = offsetBuffer.getInt(offsetIndex + 1 << 2))) {
            return EMPTY_BYTES;
        }
        int valueBufferIndex = valueEndOffset - 1 >>> 20;
        if (previousValueEndOffset - 1 >>> 20 != valueBufferIndex) {
            startOffsetInValueBuffer = 0;
            valueLength = valueEndOffset & 0xFFFFF;
        } else {
            startOffsetInValueBuffer = previousValueEndOffset & 0xFFFFF;
            valueLength = valueEndOffset - previousValueEndOffset;
        }
        byte[] value = new byte[valueLength];
        this._valueBuffers.get(valueBufferIndex).copyTo((long)startOffsetInValueBuffer, value);
        return value;
    }

    public boolean equalsValueAt(int index, byte[] valueToCompare) {
        int startOffsetInValueBuffer;
        assert (index < this._numValues);
        int offsetBufferIndex = index >>> 13;
        PinotDataBuffer offsetBuffer = this._offsetBuffers.get(offsetBufferIndex);
        int offsetIndex = index & 0x1FFF;
        int previousValueEndOffset = offsetBuffer.getInt(offsetIndex << 2);
        int valueEndOffset = offsetBuffer.getInt(offsetIndex + 1 << 2);
        int inputValueLength = valueToCompare.length;
        if (previousValueEndOffset == valueEndOffset) {
            return inputValueLength == 0;
        }
        int valueBufferIndex = valueEndOffset - 1 >>> 20;
        if (previousValueEndOffset - 1 >>> 20 != valueBufferIndex) {
            if ((valueEndOffset & 0xFFFFF) != inputValueLength) {
                return false;
            }
            startOffsetInValueBuffer = 0;
        } else {
            if (valueEndOffset - previousValueEndOffset != inputValueLength) {
                return false;
            }
            startOffsetInValueBuffer = previousValueEndOffset & 0xFFFFF;
        }
        PinotDataBuffer valueBuffer = this._valueBuffers.get(valueBufferIndex);
        if (inputValueLength <= 10) {
            for (int i = 0; i < inputValueLength; ++i) {
                if (valueToCompare[i] == valueBuffer.getByte(startOffsetInValueBuffer + i)) continue;
                return false;
            }
            return true;
        }
        byte[] value = new byte[inputValueLength];
        valueBuffer.copyTo((long)startOffsetInValueBuffer, value);
        for (int i = 0; i < inputValueLength; ++i) {
            if (valueToCompare[i] == value[i]) continue;
            return false;
        }
        return true;
    }

    public int getNumValues() {
        return this._numValues;
    }

    public int getTotalBufferSize() {
        return this._totalBufferSize;
    }

    @Override
    public void close() throws IOException {
        PinotDataBuffer valueBuffer;
        PinotDataBuffer offsetBuffer;
        int i;
        for (i = 0; i < 2048 && (offsetBuffer = this._offsetBuffers.get(i)) != null; ++i) {
            offsetBuffer.close();
        }
        for (i = 0; i < 2048 && (valueBuffer = this._valueBuffers.get(i)) != null; ++i) {
            valueBuffer.close();
        }
    }
}

