/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.realtime.converter.stats;

import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.Set;
import org.apache.pinot.segment.spi.creator.ColumnStatistics;
import org.apache.pinot.segment.spi.datasource.DataSource;
import org.apache.pinot.segment.spi.datasource.DataSourceMetadata;
import org.apache.pinot.segment.spi.index.mutable.MutableForwardIndex;
import org.apache.pinot.segment.spi.partition.PartitionFunction;

public class MutableNoDictionaryColStatistics
implements ColumnStatistics {
    private final DataSourceMetadata _dataSourceMetadata;
    private final MutableForwardIndex _forwardIndex;

    public MutableNoDictionaryColStatistics(DataSource dataSource) {
        this._dataSourceMetadata = dataSource.getDataSourceMetadata();
        this._forwardIndex = (MutableForwardIndex)dataSource.getForwardIndex();
        Preconditions.checkState((this._forwardIndex != null ? 1 : 0) != 0, (Object)String.format("Forward index should not be null for column: %s", this._dataSourceMetadata.getFieldSpec().getName()));
    }

    public Object getMinValue() {
        return this._dataSourceMetadata.getMinValue();
    }

    public Object getMaxValue() {
        return this._dataSourceMetadata.getMaxValue();
    }

    public Object getUniqueValuesSet() {
        return null;
    }

    public int getCardinality() {
        return Integer.MIN_VALUE;
    }

    public int getLengthOfShortestElement() {
        return this._forwardIndex.getLengthOfShortestElement();
    }

    public int getLengthOfLargestElement() {
        return this._forwardIndex.getLengthOfLongestElement();
    }

    public boolean isSorted() {
        return false;
    }

    public int getTotalNumberOfEntries() {
        return this._dataSourceMetadata.getNumDocs();
    }

    public int getMaxNumberOfMultiValues() {
        return 0;
    }

    public PartitionFunction getPartitionFunction() {
        return this._dataSourceMetadata.getPartitionFunction();
    }

    public int getNumPartitions() {
        PartitionFunction partitionFunction = this._dataSourceMetadata.getPartitionFunction();
        if (partitionFunction != null) {
            return partitionFunction.getNumPartitions();
        }
        return 0;
    }

    public Map<String, String> getPartitionFunctionConfig() {
        PartitionFunction partitionFunction = this._dataSourceMetadata.getPartitionFunction();
        return partitionFunction != null ? partitionFunction.getFunctionConfig() : null;
    }

    public Set<Integer> getPartitions() {
        return this._dataSourceMetadata.getPartitions();
    }
}

