/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.realtime.converter.stats;

import com.google.common.base.Preconditions;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.pinot.segment.spi.creator.ColumnStatistics;
import org.apache.pinot.segment.spi.datasource.DataSource;
import org.apache.pinot.segment.spi.datasource.DataSourceMetadata;
import org.apache.pinot.segment.spi.index.mutable.MutableForwardIndex;
import org.apache.pinot.segment.spi.index.reader.Dictionary;
import org.apache.pinot.segment.spi.partition.PartitionFunction;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.utils.BigDecimalUtils;

public class MutableColumnStatistics
implements ColumnStatistics {
    private final DataSource _dataSource;
    private final int[] _sortedDocIdIterationOrder;
    private final Dictionary _dictionary;
    private int _minElementLength = -1;
    private int _maxElementLength = -1;

    public MutableColumnStatistics(DataSource dataSource, @Nullable int[] sortedDocIdIterationOrder) {
        this._dataSource = dataSource;
        this._sortedDocIdIterationOrder = sortedDocIdIterationOrder;
        this._dictionary = dataSource.getDictionary();
    }

    public Object getMinValue() {
        return this._dictionary.getMinVal();
    }

    public Object getMaxValue() {
        return this._dictionary.getMaxVal();
    }

    public Object getUniqueValuesSet() {
        return this._dictionary.getSortedValues();
    }

    public int getCardinality() {
        return this._dictionary.length();
    }

    public int getLengthOfShortestElement() {
        this.collectElementLengthIfNeeded();
        return this._minElementLength;
    }

    public int getLengthOfLargestElement() {
        this.collectElementLengthIfNeeded();
        return this._maxElementLength;
    }

    private void collectElementLengthIfNeeded() {
        if (this._minElementLength >= 0) {
            return;
        }
        FieldSpec.DataType storedType = this._dictionary.getValueType();
        if (storedType.isFixedWidth()) {
            this._minElementLength = storedType.size();
            this._maxElementLength = storedType.size();
            return;
        }
        this._minElementLength = Integer.MAX_VALUE;
        this._maxElementLength = 0;
        int length = this._dictionary.length();
        switch (storedType) {
            case BIG_DECIMAL: {
                for (int i = 0; i < length; ++i) {
                    int elementLength = BigDecimalUtils.byteSize((BigDecimal)this._dictionary.getBigDecimalValue(i));
                    this._minElementLength = Math.min(this._minElementLength, elementLength);
                    this._maxElementLength = Math.max(this._maxElementLength, elementLength);
                }
                break;
            }
            case STRING: {
                for (int i = 0; i < length; ++i) {
                    int elementLength = this._dictionary.getStringValue(i).getBytes(StandardCharsets.UTF_8).length;
                    this._minElementLength = Math.min(this._minElementLength, elementLength);
                    this._maxElementLength = Math.max(this._maxElementLength, elementLength);
                }
                break;
            }
            case BYTES: {
                for (int i = 0; i < length; ++i) {
                    int elementLength = this._dictionary.getBytesValue(i).length;
                    this._minElementLength = Math.min(this._minElementLength, elementLength);
                    this._maxElementLength = Math.max(this._maxElementLength, elementLength);
                }
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported stored type: " + storedType);
            }
        }
    }

    public boolean isSorted() {
        DataSourceMetadata dataSourceMetadata = this._dataSource.getDataSourceMetadata();
        if (!dataSourceMetadata.isSingleValue()) {
            return false;
        }
        if (this.getCardinality() == 1) {
            return true;
        }
        MutableForwardIndex mutableForwardIndex = (MutableForwardIndex)this._dataSource.getForwardIndex();
        Preconditions.checkState((mutableForwardIndex != null ? 1 : 0) != 0, (Object)String.format("Forward index should not be null for column: %s", dataSourceMetadata.getFieldSpec().getName()));
        int numDocs = dataSourceMetadata.getNumDocs();
        if (this._sortedDocIdIterationOrder != null) {
            int previousDictId = mutableForwardIndex.getDictId(this._sortedDocIdIterationOrder[0]);
            for (int i = 1; i < numDocs; ++i) {
                int currentDictId = mutableForwardIndex.getDictId(this._sortedDocIdIterationOrder[i]);
                if (this._dictionary.compare(previousDictId, currentDictId) > 0) {
                    return false;
                }
                previousDictId = currentDictId;
            }
        } else {
            int previousDictId = mutableForwardIndex.getDictId(0);
            for (int i = 1; i < numDocs; ++i) {
                int currentDictId = mutableForwardIndex.getDictId(i);
                if (this._dictionary.compare(previousDictId, currentDictId) > 0) {
                    return false;
                }
                previousDictId = currentDictId;
            }
        }
        return true;
    }

    public int getTotalNumberOfEntries() {
        return this._dataSource.getDataSourceMetadata().getNumValues();
    }

    public int getMaxNumberOfMultiValues() {
        return this._dataSource.getDataSourceMetadata().getMaxNumValuesPerMVEntry();
    }

    public PartitionFunction getPartitionFunction() {
        return this._dataSource.getDataSourceMetadata().getPartitionFunction();
    }

    public int getNumPartitions() {
        PartitionFunction partitionFunction = this._dataSource.getDataSourceMetadata().getPartitionFunction();
        if (partitionFunction != null) {
            return partitionFunction.getNumPartitions();
        }
        return 0;
    }

    public Map<String, String> getPartitionFunctionConfig() {
        PartitionFunction partitionFunction = this._dataSource.getDataSourceMetadata().getPartitionFunction();
        return partitionFunction != null ? partitionFunction.getFunctionConfig() : null;
    }

    public Set<Integer> getPartitions() {
        return this._dataSource.getDataSourceMetadata().getPartitions();
    }
}

