/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.indexsegment.immutable;

import com.google.common.base.Preconditions;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.apache.pinot.common.utils.HashUtil;
import org.apache.pinot.segment.local.dedup.PartitionDedupMetadataManager;
import org.apache.pinot.segment.local.segment.index.datasource.ImmutableDataSource;
import org.apache.pinot.segment.local.segment.readers.PinotSegmentColumnReader;
import org.apache.pinot.segment.local.segment.readers.PinotSegmentRecordReader;
import org.apache.pinot.segment.local.startree.v2.store.StarTreeIndexContainer;
import org.apache.pinot.segment.local.upsert.PartitionUpsertMetadataManager;
import org.apache.pinot.segment.spi.ColumnMetadata;
import org.apache.pinot.segment.spi.FetchContext;
import org.apache.pinot.segment.spi.ImmutableSegment;
import org.apache.pinot.segment.spi.IndexSegment;
import org.apache.pinot.segment.spi.datasource.DataSource;
import org.apache.pinot.segment.spi.index.column.ColumnIndexContainer;
import org.apache.pinot.segment.spi.index.metadata.SegmentMetadataImpl;
import org.apache.pinot.segment.spi.index.mutable.ThreadSafeMutableRoaringBitmap;
import org.apache.pinot.segment.spi.index.reader.Dictionary;
import org.apache.pinot.segment.spi.index.reader.ForwardIndexReader;
import org.apache.pinot.segment.spi.index.reader.InvertedIndexReader;
import org.apache.pinot.segment.spi.index.startree.StarTreeV2;
import org.apache.pinot.segment.spi.store.SegmentDirectory;
import org.apache.pinot.segment.spi.store.SegmentDirectoryPaths;
import org.apache.pinot.spi.data.readers.GenericRow;
import org.roaringbitmap.buffer.ImmutableRoaringBitmap;
import org.roaringbitmap.buffer.MutableRoaringBitmap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImmutableSegmentImpl
implements ImmutableSegment {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImmutableSegmentImpl.class);
    private final SegmentDirectory _segmentDirectory;
    private final SegmentMetadataImpl _segmentMetadata;
    private final Map<String, ColumnIndexContainer> _indexContainerMap;
    private final StarTreeIndexContainer _starTreeIndexContainer;
    private final Map<String, DataSource> _dataSources;
    private PartitionDedupMetadataManager _partitionDedupMetadataManager;
    private PartitionUpsertMetadataManager _partitionUpsertMetadataManager;
    private ThreadSafeMutableRoaringBitmap _validDocIds;

    public ImmutableSegmentImpl(SegmentDirectory segmentDirectory, SegmentMetadataImpl segmentMetadata, Map<String, ColumnIndexContainer> columnIndexContainerMap, @Nullable StarTreeIndexContainer starTreeIndexContainer) {
        this._segmentDirectory = segmentDirectory;
        this._segmentMetadata = segmentMetadata;
        this._indexContainerMap = columnIndexContainerMap;
        this._starTreeIndexContainer = starTreeIndexContainer;
        this._dataSources = new HashMap<String, DataSource>(HashUtil.getHashMapCapacity((int)segmentMetadata.getColumnMetadataMap().size()));
        for (Map.Entry entry : segmentMetadata.getColumnMetadataMap().entrySet()) {
            String colName = (String)entry.getKey();
            this._dataSources.put(colName, new ImmutableDataSource((ColumnMetadata)entry.getValue(), this._indexContainerMap.get(colName)));
        }
    }

    public void enableDedup(PartitionDedupMetadataManager partitionDedupMetadataManager) {
        this._partitionDedupMetadataManager = partitionDedupMetadataManager;
    }

    public void enableUpsert(PartitionUpsertMetadataManager partitionUpsertMetadataManager, ThreadSafeMutableRoaringBitmap validDocIds) {
        this._partitionUpsertMetadataManager = partitionUpsertMetadataManager;
        this._validDocIds = validDocIds;
    }

    @Nullable
    public MutableRoaringBitmap loadValidDocIdsFromSnapshot() {
        File validDocIdsSnapshotFile = this.getValidDocIdsSnapshotFile();
        if (validDocIdsSnapshotFile.exists()) {
            try {
                byte[] bytes = FileUtils.readFileToByteArray((File)validDocIdsSnapshotFile);
                MutableRoaringBitmap validDocIds = new ImmutableRoaringBitmap(ByteBuffer.wrap(bytes)).toMutableRoaringBitmap();
                LOGGER.info("Loaded valid doc ids for segment: {} with: {} valid docs", (Object)this.getSegmentName(), (Object)validDocIds.getCardinality());
                return validDocIds;
            }
            catch (Exception e) {
                LOGGER.warn("Caught exception while loading valid doc ids from snapshot file: {}, ignoring the snapshot", (Object)validDocIdsSnapshotFile);
            }
        }
        return null;
    }

    public void persistValidDocIdsSnapshot(MutableRoaringBitmap validDocIds) {
        File validDocIdsSnapshotFile = this.getValidDocIdsSnapshotFile();
        try {
            if (validDocIdsSnapshotFile.exists()) {
                FileUtils.delete((File)validDocIdsSnapshotFile);
            }
            try (DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream(validDocIdsSnapshotFile));){
                validDocIds.serialize((DataOutput)dataOutputStream);
            }
            LOGGER.info("Persisted valid doc ids for segment: {} with: {} valid docs", (Object)this.getSegmentName(), (Object)validDocIds.getCardinality());
        }
        catch (Exception e) {
            LOGGER.warn("Caught exception while persisting valid doc ids to snapshot file: {}, skipping", (Object)validDocIdsSnapshotFile);
        }
    }

    public void deleteValidDocIdsSnapshot() {
        File validDocIdsSnapshotFile = this.getValidDocIdsSnapshotFile();
        if (validDocIdsSnapshotFile.exists()) {
            try {
                FileUtils.delete((File)validDocIdsSnapshotFile);
                LOGGER.info("Deleted valid doc ids snapshot for segment: {}", (Object)this.getSegmentName());
            }
            catch (Exception e) {
                LOGGER.warn("Caught exception while deleting valid doc ids snapshot file: {}, skipping", (Object)validDocIdsSnapshotFile);
            }
        }
    }

    private File getValidDocIdsSnapshotFile() {
        return new File(SegmentDirectoryPaths.findSegmentDirectory((File)this._segmentMetadata.getIndexDir()), "validdocids.bitmap.snapshot");
    }

    public Dictionary getDictionary(String column) {
        ColumnIndexContainer container = this._indexContainerMap.get(column);
        if (container == null) {
            throw new NullPointerException("Invalid column: " + column);
        }
        return container.getDictionary();
    }

    public ForwardIndexReader getForwardIndex(String column) {
        return this._indexContainerMap.get(column).getForwardIndex();
    }

    public InvertedIndexReader getInvertedIndex(String column) {
        return this._indexContainerMap.get(column).getInvertedIndex();
    }

    public long getSegmentSizeBytes() {
        return this._segmentDirectory.getDiskSizeBytes();
    }

    @Nullable
    public String getTier() {
        return this._segmentDirectory.getTier();
    }

    public String getSegmentName() {
        return this._segmentMetadata.getName();
    }

    public SegmentMetadataImpl getSegmentMetadata() {
        return this._segmentMetadata;
    }

    public DataSource getDataSource(String column) {
        DataSource result = this._dataSources.get(column);
        Preconditions.checkNotNull((Object)result, (String)"DataSource for %s should not be null. Potentially invalid column name specified.", (Object)column);
        return result;
    }

    public Set<String> getColumnNames() {
        return this._segmentMetadata.getSchema().getColumnNames();
    }

    public Set<String> getPhysicalColumnNames() {
        return this._segmentMetadata.getSchema().getPhysicalColumnNames();
    }

    public void prefetch(FetchContext fetchContext) {
        this._segmentDirectory.prefetch(fetchContext);
    }

    public void acquire(FetchContext fetchContext) {
        this._segmentDirectory.acquire(fetchContext);
    }

    public void release(FetchContext fetchContext) {
        this._segmentDirectory.release(fetchContext);
    }

    public void destroy() {
        String segmentName = this.getSegmentName();
        LOGGER.info("Trying to destroy segment : {}", (Object)segmentName);
        if (this._partitionUpsertMetadataManager != null) {
            this._partitionUpsertMetadataManager.removeSegment((IndexSegment)this);
        }
        if (this._partitionDedupMetadataManager != null) {
            this._partitionDedupMetadataManager.removeSegment((IndexSegment)this);
        }
        for (Map.Entry<String, ColumnIndexContainer> entry : this._indexContainerMap.entrySet()) {
            try {
                entry.getValue().close();
            }
            catch (IOException e) {
                LOGGER.error("Failed to close indexes for column: {}. Continuing with error.", (Object)entry.getKey(), (Object)e);
            }
        }
        try {
            this._segmentDirectory.close();
        }
        catch (Exception e) {
            LOGGER.error("Failed to close segment directory: {}. Continuing with error.", (Object)this._segmentDirectory, (Object)e);
        }
        if (this._starTreeIndexContainer != null) {
            try {
                this._starTreeIndexContainer.close();
            }
            catch (IOException e) {
                LOGGER.error("Failed to close star-tree. Continuing with error.", (Throwable)e);
            }
        }
    }

    public List<StarTreeV2> getStarTrees() {
        return this._starTreeIndexContainer != null ? this._starTreeIndexContainer.getStarTrees() : null;
    }

    @Nullable
    public ThreadSafeMutableRoaringBitmap getValidDocIds() {
        return this._validDocIds;
    }

    public GenericRow getRecord(int docId, GenericRow reuse) {
        GenericRow genericRow;
        PinotSegmentRecordReader recordReader = new PinotSegmentRecordReader();
        try {
            recordReader.init((IndexSegment)this);
            recordReader.getRecord(docId, reuse);
            genericRow = reuse;
        }
        catch (Throwable throwable) {
            try {
                try {
                    recordReader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new RuntimeException("Caught exception while reading record for docId: " + docId, e);
            }
        }
        recordReader.close();
        return genericRow;
    }

    public Object getValue(int docId, String column) {
        Object object;
        PinotSegmentColumnReader columnReader = new PinotSegmentColumnReader((IndexSegment)this, column);
        try {
            object = columnReader.getValue(docId);
        }
        catch (Throwable throwable) {
            try {
                try {
                    columnReader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("Caught exception while reading value for docId: %d, column: %s", docId, column), e);
            }
        }
        columnReader.close();
        return object;
    }
}

