/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.function;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.pinot.common.function.FunctionInfo;
import org.apache.pinot.common.function.FunctionInvoker;
import org.apache.pinot.common.function.FunctionRegistry;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.request.context.FunctionContext;
import org.apache.pinot.common.request.context.RequestContextUtils;
import org.apache.pinot.segment.local.function.FunctionEvaluator;
import org.apache.pinot.spi.data.readers.GenericRow;

public class InbuiltFunctionEvaluator
implements FunctionEvaluator {
    private final ExecutableNode _rootNode;
    private final List<String> _arguments = new ArrayList<String>();

    public InbuiltFunctionEvaluator(String functionExpression) {
        this._rootNode = this.planExecution(RequestContextUtils.getExpression((String)functionExpression));
    }

    private ExecutableNode planExecution(ExpressionContext expression) {
        switch (expression.getType()) {
            case LITERAL: {
                return new ConstantExecutionNode(expression.getLiteralString());
            }
            case IDENTIFIER: {
                String columnName = expression.getIdentifier();
                ColumnExecutionNode columnExecutionNode = new ColumnExecutionNode(columnName, this._arguments.size());
                this._arguments.add(columnName);
                return columnExecutionNode;
            }
            case FUNCTION: {
                String functionName;
                FunctionContext function = expression.getFunction();
                List arguments = function.getArguments();
                int numArguments = arguments.size();
                ExecutableNode[] childNodes = new ExecutableNode[numArguments];
                for (int i = 0; i < numArguments; ++i) {
                    childNodes[i] = this.planExecution((ExpressionContext)arguments.get(i));
                }
                switch (functionName = function.getFunctionName()) {
                    case "and": {
                        return new AndExecutionNode(childNodes);
                    }
                    case "or": {
                        return new OrExecutionNode(childNodes);
                    }
                    case "not": {
                        Preconditions.checkState((numArguments == 1 ? 1 : 0) != 0, (String)"NOT function expects 1 argument, got: %s", (int)numArguments);
                        return new NotExecutionNode(childNodes[0]);
                    }
                }
                FunctionInfo functionInfo = FunctionRegistry.getFunctionInfo((String)functionName, (int)numArguments);
                if (functionInfo == null) {
                    if (FunctionRegistry.containsFunction((String)functionName)) {
                        throw new IllegalStateException(String.format("Unsupported function: %s with %d parameters", functionName, numArguments));
                    }
                    throw new IllegalStateException(String.format("Unsupported function: %s not found", functionName));
                }
                return new FunctionExecutionNode(functionInfo, childNodes);
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public List<String> getArguments() {
        return this._arguments;
    }

    @Override
    public Object evaluate(GenericRow row) {
        return this._rootNode.execute(row);
    }

    @Override
    public Object evaluate(Object[] values) {
        return this._rootNode.execute(values);
    }

    private static class ColumnExecutionNode
    implements ExecutableNode {
        final String _column;
        final int _id;

        ColumnExecutionNode(String column, int id) {
            this._column = column;
            this._id = id;
        }

        @Override
        public Object execute(GenericRow row) {
            return row.getValue(this._column);
        }

        @Override
        public Object execute(Object[] values) {
            return values[this._id];
        }

        public String toString() {
            return this._column;
        }
    }

    private static class ConstantExecutionNode
    implements ExecutableNode {
        final String _value;

        ConstantExecutionNode(String value) {
            this._value = value;
        }

        @Override
        public String execute(GenericRow row) {
            return this._value;
        }

        @Override
        public Object execute(Object[] values) {
            return this._value;
        }

        public String toString() {
            return String.format("'%s'", this._value);
        }
    }

    private static class FunctionExecutionNode
    implements ExecutableNode {
        final FunctionInvoker _functionInvoker;
        final FunctionInfo _functionInfo;
        final ExecutableNode[] _argumentNodes;
        final Object[] _arguments;

        FunctionExecutionNode(FunctionInfo functionInfo, ExecutableNode[] argumentNodes) {
            this._functionInvoker = new FunctionInvoker(functionInfo);
            this._functionInfo = functionInfo;
            this._argumentNodes = argumentNodes;
            this._arguments = new Object[this._argumentNodes.length];
        }

        @Override
        public Object execute(GenericRow row) {
            try {
                int numArguments = this._argumentNodes.length;
                for (int i = 0; i < numArguments; ++i) {
                    this._arguments[i] = this._argumentNodes[i].execute(row);
                }
                if (!this._functionInfo.hasNullableParameters()) {
                    for (Object argument : this._arguments) {
                        if (argument != null) continue;
                        return null;
                    }
                }
                this._functionInvoker.convertTypes(this._arguments);
                return this._functionInvoker.invoke(this._arguments);
            }
            catch (Exception e) {
                throw new RuntimeException("Caught exception while executing function: " + this, e);
            }
        }

        @Override
        public Object execute(Object[] values) {
            try {
                int numArguments = this._argumentNodes.length;
                for (int i = 0; i < numArguments; ++i) {
                    this._arguments[i] = this._argumentNodes[i].execute(values);
                }
                if (!this._functionInfo.hasNullableParameters()) {
                    for (Object argument : this._arguments) {
                        if (argument != null) continue;
                        return null;
                    }
                }
                this._functionInvoker.convertTypes(this._arguments);
                return this._functionInvoker.invoke(this._arguments);
            }
            catch (Exception e) {
                throw new RuntimeException("Caught exception while executing function: " + this, e);
            }
        }

        public String toString() {
            return this._functionInvoker.getMethod().getName() + "(" + StringUtils.join((Object[])this._argumentNodes, (char)',') + ")";
        }
    }

    private static class AndExecutionNode
    implements ExecutableNode {
        private final ExecutableNode[] _argumentNodes;

        AndExecutionNode(ExecutableNode[] argumentNodes) {
            this._argumentNodes = argumentNodes;
        }

        @Override
        public Object execute(GenericRow row) {
            for (ExecutableNode executableNode : this._argumentNodes) {
                Boolean res = (Boolean)executableNode.execute(row);
                if (res.booleanValue()) continue;
                return false;
            }
            return true;
        }

        @Override
        public Object execute(Object[] values) {
            for (ExecutableNode executableNode : this._argumentNodes) {
                Boolean res = (Boolean)executableNode.execute(values);
                if (res.booleanValue()) continue;
                return false;
            }
            return true;
        }
    }

    private static class OrExecutionNode
    implements ExecutableNode {
        private final ExecutableNode[] _argumentNodes;

        OrExecutionNode(ExecutableNode[] argumentNodes) {
            this._argumentNodes = argumentNodes;
        }

        @Override
        public Object execute(GenericRow row) {
            for (ExecutableNode executableNode : this._argumentNodes) {
                Boolean res = (Boolean)executableNode.execute(row);
                if (!res.booleanValue()) continue;
                return true;
            }
            return false;
        }

        @Override
        public Object execute(Object[] values) {
            for (ExecutableNode executableNode : this._argumentNodes) {
                Boolean res = (Boolean)executableNode.execute(values);
                if (!res.booleanValue()) continue;
                return true;
            }
            return false;
        }
    }

    private static class NotExecutionNode
    implements ExecutableNode {
        private final ExecutableNode _argumentNode;

        NotExecutionNode(ExecutableNode argumentNode) {
            this._argumentNode = argumentNode;
        }

        @Override
        public Object execute(GenericRow row) {
            return (Boolean)this._argumentNode.execute(row) == false;
        }

        @Override
        public Object execute(Object[] values) {
            return (Boolean)this._argumentNode.execute(values) == false;
        }
    }

    private static interface ExecutableNode {
        public Object execute(GenericRow var1);

        public Object execute(Object[] var1);
    }
}

