/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.dedup;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.pinot.common.metrics.ServerMetrics;
import org.apache.pinot.segment.local.dedup.PartitionDedupMetadataManager;
import org.apache.pinot.spi.config.table.HashFunction;

public class TableDedupMetadataManager {
    private final Map<Integer, PartitionDedupMetadataManager> _partitionMetadataManagerMap = new ConcurrentHashMap<Integer, PartitionDedupMetadataManager>();
    private final String _tableNameWithType;
    private final List<String> _primaryKeyColumns;
    private final ServerMetrics _serverMetrics;
    private final HashFunction _hashFunction;

    public TableDedupMetadataManager(String tableNameWithType, List<String> primaryKeyColumns, ServerMetrics serverMetrics, HashFunction hashFunction) {
        this._tableNameWithType = tableNameWithType;
        this._primaryKeyColumns = primaryKeyColumns;
        this._serverMetrics = serverMetrics;
        this._hashFunction = hashFunction;
    }

    public PartitionDedupMetadataManager getOrCreatePartitionManager(int partitionId) {
        return this._partitionMetadataManagerMap.computeIfAbsent(partitionId, k -> new PartitionDedupMetadataManager(this._tableNameWithType, this._primaryKeyColumns, (int)k, this._serverMetrics, this._hashFunction));
    }
}

