/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.dedup;

import com.google.common.annotations.VisibleForTesting;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.pinot.common.metrics.AbstractMetrics;
import org.apache.pinot.common.metrics.ServerGauge;
import org.apache.pinot.common.metrics.ServerMetrics;
import org.apache.pinot.segment.local.segment.readers.PinotSegmentColumnReader;
import org.apache.pinot.segment.local.utils.HashUtils;
import org.apache.pinot.segment.spi.IndexSegment;
import org.apache.pinot.spi.config.table.HashFunction;
import org.apache.pinot.spi.data.readers.PrimaryKey;
import org.apache.pinot.spi.utils.ByteArray;

public class PartitionDedupMetadataManager {
    private final String _tableNameWithType;
    private final List<String> _primaryKeyColumns;
    private final int _partitionId;
    private final ServerMetrics _serverMetrics;
    private final HashFunction _hashFunction;
    @VisibleForTesting
    final ConcurrentHashMap<Object, IndexSegment> _primaryKeyToSegmentMap = new ConcurrentHashMap();

    public PartitionDedupMetadataManager(String tableNameWithType, List<String> primaryKeyColumns, int partitionId, ServerMetrics serverMetrics, HashFunction hashFunction) {
        this._tableNameWithType = tableNameWithType;
        this._primaryKeyColumns = primaryKeyColumns;
        this._partitionId = partitionId;
        this._serverMetrics = serverMetrics;
        this._hashFunction = hashFunction;
    }

    public void addSegment(IndexSegment segment) {
        Iterator<PrimaryKey> primaryKeyIterator = this.getPrimaryKeyIterator(segment);
        while (primaryKeyIterator.hasNext()) {
            PrimaryKey pk = primaryKeyIterator.next();
            this._primaryKeyToSegmentMap.put(HashUtils.hashPrimaryKey(pk, this._hashFunction), segment);
        }
        this._serverMetrics.setValueOfPartitionGauge(this._tableNameWithType, this._partitionId, (AbstractMetrics.Gauge)ServerGauge.DEDUP_PRIMARY_KEYS_COUNT, (long)this._primaryKeyToSegmentMap.size());
    }

    public void removeSegment(IndexSegment segment) {
        Iterator<PrimaryKey> primaryKeyIterator = this.getPrimaryKeyIterator(segment);
        while (primaryKeyIterator.hasNext()) {
            PrimaryKey pk = primaryKeyIterator.next();
            this._primaryKeyToSegmentMap.compute(HashUtils.hashPrimaryKey(pk, this._hashFunction), (primaryKey, currentSegment) -> {
                if (currentSegment == segment) {
                    return null;
                }
                return currentSegment;
            });
        }
        this._serverMetrics.setValueOfPartitionGauge(this._tableNameWithType, this._partitionId, (AbstractMetrics.Gauge)ServerGauge.DEDUP_PRIMARY_KEYS_COUNT, (long)this._primaryKeyToSegmentMap.size());
    }

    @VisibleForTesting
    Iterator<PrimaryKey> getPrimaryKeyIterator(IndexSegment segment) {
        final HashMap<String, PinotSegmentColumnReader> columnToReaderMap = new HashMap<String, PinotSegmentColumnReader>();
        for (String primaryKeyColumn : this._primaryKeyColumns) {
            columnToReaderMap.put(primaryKeyColumn, new PinotSegmentColumnReader(segment, primaryKeyColumn));
        }
        final int numTotalDocs = segment.getSegmentMetadata().getTotalDocs();
        final int numPrimaryKeyColumns = this._primaryKeyColumns.size();
        return new Iterator<PrimaryKey>(){
            private int _docId = 0;

            @Override
            public boolean hasNext() {
                return this._docId < numTotalDocs;
            }

            @Override
            public PrimaryKey next() {
                Object[] values = new Object[numPrimaryKeyColumns];
                for (int i = 0; i < numPrimaryKeyColumns; ++i) {
                    Object value = ((PinotSegmentColumnReader)columnToReaderMap.get(PartitionDedupMetadataManager.this._primaryKeyColumns.get(i))).getValue(this._docId);
                    if (value instanceof byte[]) {
                        value = new ByteArray((byte[])value);
                    }
                    values[i] = value;
                }
                ++this._docId;
                return new PrimaryKey(values);
            }
        };
    }

    public boolean checkRecordPresentOrUpdate(PrimaryKey pk, IndexSegment indexSegment) {
        boolean present;
        boolean bl = present = this._primaryKeyToSegmentMap.putIfAbsent(HashUtils.hashPrimaryKey(pk, this._hashFunction), indexSegment) != null;
        if (!present) {
            this._serverMetrics.setValueOfPartitionGauge(this._tableNameWithType, this._partitionId, (AbstractMetrics.Gauge)ServerGauge.DEDUP_PRIMARY_KEYS_COUNT, (long)this._primaryKeyToSegmentMap.size());
        }
        return present;
    }
}

