/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.customobject;

import com.google.common.base.Preconditions;
import com.tdunning.math.stats.TDigest;
import org.apache.pinot.segment.local.utils.CustomSerDeUtils;
import org.apache.pinot.spi.utils.BytesUtils;

public class SerializedTDigest
implements Comparable<SerializedTDigest> {
    private final double _percentile;
    private final TDigest _tDigest;

    public SerializedTDigest(TDigest tDigest, double percentile) {
        this._tDigest = tDigest;
        this._percentile = percentile / 100.0;
    }

    @Override
    public int compareTo(SerializedTDigest other) {
        Preconditions.checkArgument((other._percentile == this._percentile ? 1 : 0) != 0, (Object)"Percentile number doesn't match!");
        return Double.compare(this._tDigest.quantile(this._percentile), other._tDigest.quantile(this._percentile));
    }

    public String toString() {
        return BytesUtils.toHexString((byte[])CustomSerDeUtils.TDIGEST_SER_DE.serialize(this._tDigest));
    }
}

