/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.customobject;

import java.nio.ByteBuffer;
import java.util.Comparator;
import org.apache.commons.math.stat.descriptive.moment.FourthMoment;
import org.apache.commons.math.stat.descriptive.moment.Kurtosis;
import org.apache.commons.math.stat.descriptive.moment.Skewness;
import org.apache.commons.math.stat.descriptive.moment.ThirdMoment;

public class PinotFourthMoment
extends FourthMoment
implements Comparable<PinotFourthMoment> {
    private static final Comparator<PinotFourthMoment> COMPARATOR = Comparator.naturalOrder().thenComparingLong(x -> x.n).thenComparingDouble(x -> x.m1).thenComparingDouble(x -> x.m2).thenComparingDouble(x -> x.m3).thenComparingDouble(x -> x.m4);

    public void combine(PinotFourthMoment other) {
        this.combine(other.n, other.m1, other.m2, other.m3, other.m4);
    }

    public void combine(long bN, double bM1, double bM2, double bM3, double bM4) {
        if (bN == 0L) {
            return;
        }
        if (this.n == 0L) {
            this.n = bN;
            this.m1 = bM1;
            this.m2 = bM2;
            this.m3 = bM3;
            this.m4 = bM4;
            return;
        }
        long aN = this.n;
        double aM1 = this.m1;
        double aM2 = this.m2;
        double aM3 = this.m3;
        double aM4 = this.m4;
        long n = aN + bN;
        double m1 = ((double)aN * aM1 + (double)bN * bM1) / (double)n;
        double delta = bM1 - aM1;
        double delta2 = delta * delta;
        double m2 = aM2 + bM2 + delta2 * (double)aN * (double)bN / (double)n;
        double delta3 = delta2 * delta;
        double m3 = aM3 + bM3 + delta3 * (double)aN * (double)bN * (double)(aN - bN) / (double)(n * n) + 3.0 * delta * ((double)aN * bM2 - (double)bN * aM2) / (double)n;
        double delta4 = delta3 * delta;
        double n3 = (double)n * (double)n * (double)n;
        double m4 = aM4 + bM4 + delta4 * (double)aN * (double)bN * (double)(aN * aN - aN * bN + bN * bN) / n3 + 6.0 * delta2 * ((double)(aN * aN) * bM2 + (double)(bN * bN) * aM2) / (double)(n * n) + 4.0 * delta * ((double)aN * bM3 - (double)bN * aM3) / (double)n;
        this.n = n;
        this.m1 = m1;
        this.m2 = m2;
        this.m3 = m3;
        this.m4 = m4;
    }

    public double skew() {
        return new Skewness((ThirdMoment)this).getResult();
    }

    public double kurtosis() {
        return new Kurtosis((FourthMoment)this).getResult();
    }

    public byte[] serialize() {
        ByteBuffer buff = ByteBuffer.allocate(40);
        buff.putLong(this.n).putDouble(this.m1).putDouble(this.m2).putDouble(this.m3).putDouble(this.m4);
        return buff.array();
    }

    public static PinotFourthMoment fromBytes(byte[] bytes) {
        return PinotFourthMoment.fromBytes(ByteBuffer.wrap(bytes));
    }

    public static PinotFourthMoment fromBytes(ByteBuffer buff) {
        PinotFourthMoment moment = new PinotFourthMoment();
        moment.n = buff.getLong();
        moment.m1 = buff.getDouble();
        moment.m2 = buff.getDouble();
        moment.m3 = buff.getDouble();
        moment.m4 = buff.getDouble();
        return moment;
    }

    @Override
    public int compareTo(PinotFourthMoment o) {
        return COMPARATOR.compare(this, o);
    }
}

