/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.aggregator;

import org.apache.pinot.segment.local.aggregator.AvgValueAggregator;
import org.apache.pinot.segment.local.aggregator.CountValueAggregator;
import org.apache.pinot.segment.local.aggregator.DistinctCountBitmapValueAggregator;
import org.apache.pinot.segment.local.aggregator.DistinctCountHLLValueAggregator;
import org.apache.pinot.segment.local.aggregator.MaxValueAggregator;
import org.apache.pinot.segment.local.aggregator.MinMaxRangeValueAggregator;
import org.apache.pinot.segment.local.aggregator.MinValueAggregator;
import org.apache.pinot.segment.local.aggregator.PercentileEstValueAggregator;
import org.apache.pinot.segment.local.aggregator.PercentileTDigestValueAggregator;
import org.apache.pinot.segment.local.aggregator.SumPrecisionValueAggregator;
import org.apache.pinot.segment.local.aggregator.SumValueAggregator;
import org.apache.pinot.segment.local.aggregator.ValueAggregator;
import org.apache.pinot.segment.spi.AggregationFunctionType;
import org.apache.pinot.spi.data.FieldSpec;

public class ValueAggregatorFactory {
    private ValueAggregatorFactory() {
    }

    public static ValueAggregator getValueAggregator(AggregationFunctionType aggregationType) {
        switch (aggregationType) {
            case COUNT: {
                return new CountValueAggregator();
            }
            case MIN: {
                return new MinValueAggregator();
            }
            case MAX: {
                return new MaxValueAggregator();
            }
            case SUM: {
                return new SumValueAggregator();
            }
            case SUMPRECISION: {
                return new SumPrecisionValueAggregator();
            }
            case AVG: {
                return new AvgValueAggregator();
            }
            case MINMAXRANGE: {
                return new MinMaxRangeValueAggregator();
            }
            case DISTINCTCOUNTBITMAP: {
                return new DistinctCountBitmapValueAggregator();
            }
            case DISTINCTCOUNTHLL: 
            case DISTINCTCOUNTRAWHLL: {
                return new DistinctCountHLLValueAggregator();
            }
            case PERCENTILEEST: 
            case PERCENTILERAWEST: {
                return new PercentileEstValueAggregator();
            }
            case PERCENTILETDIGEST: 
            case PERCENTILERAWTDIGEST: {
                return new PercentileTDigestValueAggregator();
            }
        }
        throw new IllegalStateException("Unsupported aggregation type: " + aggregationType);
    }

    public static FieldSpec.DataType getAggregatedValueType(AggregationFunctionType aggregationType) {
        switch (aggregationType) {
            case COUNT: {
                return CountValueAggregator.AGGREGATED_VALUE_TYPE;
            }
            case MIN: {
                return MinValueAggregator.AGGREGATED_VALUE_TYPE;
            }
            case MAX: {
                return MaxValueAggregator.AGGREGATED_VALUE_TYPE;
            }
            case SUM: {
                return SumValueAggregator.AGGREGATED_VALUE_TYPE;
            }
            case SUMPRECISION: {
                return SumPrecisionValueAggregator.AGGREGATED_VALUE_TYPE;
            }
            case AVG: {
                return AvgValueAggregator.AGGREGATED_VALUE_TYPE;
            }
            case MINMAXRANGE: {
                return MinMaxRangeValueAggregator.AGGREGATED_VALUE_TYPE;
            }
            case DISTINCTCOUNTBITMAP: {
                return DistinctCountBitmapValueAggregator.AGGREGATED_VALUE_TYPE;
            }
            case DISTINCTCOUNTHLL: 
            case DISTINCTCOUNTRAWHLL: {
                return DistinctCountHLLValueAggregator.AGGREGATED_VALUE_TYPE;
            }
            case PERCENTILEEST: 
            case PERCENTILERAWEST: {
                return PercentileEstValueAggregator.AGGREGATED_VALUE_TYPE;
            }
            case PERCENTILETDIGEST: 
            case PERCENTILERAWTDIGEST: {
                return PercentileTDigestValueAggregator.AGGREGATED_VALUE_TYPE;
            }
        }
        throw new IllegalStateException("Unsupported aggregation type: " + aggregationType);
    }
}

