/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.aggregator;

import org.apache.pinot.segment.local.aggregator.ValueAggregator;
import org.apache.pinot.segment.spi.AggregationFunctionType;
import org.apache.pinot.spi.data.FieldSpec;

public class CountValueAggregator
implements ValueAggregator<Object, Long> {
    public static final FieldSpec.DataType AGGREGATED_VALUE_TYPE = FieldSpec.DataType.LONG;

    @Override
    public AggregationFunctionType getAggregationType() {
        return AggregationFunctionType.COUNT;
    }

    @Override
    public FieldSpec.DataType getAggregatedValueType() {
        return AGGREGATED_VALUE_TYPE;
    }

    @Override
    public Long getInitialAggregatedValue(Object rawValue) {
        return 1L;
    }

    @Override
    public Long applyRawValue(Long value, Object rawValue) {
        return value + 1L;
    }

    @Override
    public Long applyAggregatedValue(Long value, Long aggregatedValue) {
        return value + aggregatedValue;
    }

    @Override
    public Long cloneAggregatedValue(Long value) {
        return value;
    }

    @Override
    public int getMaxAggregatedValueByteSize() {
        return 8;
    }

    @Override
    public byte[] serializeAggregatedValue(Long value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Long deserializeAggregatedValue(byte[] bytes) {
        throw new UnsupportedOperationException();
    }
}

