/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.data.readers;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.zip.GZIPInputStream;

public class RecordReaderUtils {
    private RecordReaderUtils() {
    }

    public static BufferedReader getBufferedReader(File dataFile) throws IOException {
        return new BufferedReader(new InputStreamReader(RecordReaderUtils.getInputStream(dataFile), StandardCharsets.UTF_8));
    }

    public static BufferedInputStream getBufferedInputStream(File dataFile) throws IOException {
        return new BufferedInputStream(RecordReaderUtils.getInputStream(dataFile));
    }

    public static InputStream getInputStream(File dataFile) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(dataFile);
        try {
            return new GZIPInputStream(fileInputStream);
        }
        catch (Exception e) {
            fileInputStream.close();
            return new FileInputStream(dataFile);
        }
    }

    public static File unpackIfRequired(File dataFile, String extension) throws IOException {
        if (RecordReaderUtils.isGZippedFile(dataFile)) {
            try (InputStream inputStream = RecordReaderUtils.getInputStream(dataFile);){
                Object targetFileName = dataFile.getName();
                targetFileName = ((String)targetFileName).endsWith(".gz") ? ((String)targetFileName).substring(0, ((String)targetFileName).length() - 3) : (String)targetFileName + "." + extension;
                File targetFile = new File(dataFile.getParentFile(), (String)targetFileName);
                Files.copy(inputStream, targetFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                File file = targetFile;
                return file;
            }
        }
        return dataFile;
    }

    public static boolean isGZippedFile(File file) throws IOException {
        int magic = 0;
        try (RandomAccessFile raf = new RandomAccessFile(file, "r");){
            magic = raf.read() & 0xFF | raf.read() << 8 & 0xFF00;
        }
        return magic == 35615;
    }
}

