/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.config.user;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.pinot.spi.config.BaseJsonConfig;
import org.apache.pinot.spi.config.user.AccessType;
import org.apache.pinot.spi.config.user.ComponentType;
import org.apache.pinot.spi.config.user.RoleType;

public class UserConfig
extends BaseJsonConfig {
    public static final String USERNAME_KEY = "username";
    public static final String PASSWORD_KEY = "password";
    public static final String COMPONET_KEY = "component";
    public static final String ROLE_KEY = "role";
    public static final String AUTH_TOKEN_KEY = "authToken";
    public static final String TABLES_KEY = "tables";
    public static final String PERMISSIONS_KEY = "permissions";
    @JsonPropertyDescription(value="The name of User")
    private String _username;
    @JsonPropertyDescription(value="The password of User")
    private String _password;
    @JsonPropertyDescription(value="The name of Component")
    private ComponentType _componentType;
    @JsonPropertyDescription(value="The role of user")
    private RoleType _roleType;
    @JsonPropertyDescription(value="The tables owned of User")
    private List<String> _tables;
    @JsonPropertyDescription(value="The table permission of User")
    private List<AccessType> _permissions;

    @JsonCreator
    public UserConfig(@JsonProperty(value="username", required=true) String username, @JsonProperty(value="password", required=true) String password, @JsonProperty(value="component", required=true) String component, @JsonProperty(value="role", required=true) String role, @JsonProperty(value="tables") @Nullable List<String> tableList, @JsonProperty(value="permissions") @Nullable List<AccessType> permissionList) {
        Preconditions.checkArgument((username != null ? 1 : 0) != 0, (Object)"'username' must be configured");
        Preconditions.checkArgument((password != null ? 1 : 0) != 0, (Object)"'password' must be configured");
        this._username = username;
        this._password = password;
        this._componentType = ComponentType.valueOf(component.toUpperCase());
        this._roleType = RoleType.valueOf(role.toUpperCase());
        this._tables = tableList;
        this._permissions = permissionList;
    }

    @JsonProperty(value="username")
    public String getUserName() {
        return this._username;
    }

    public String getUsernameWithComponent() {
        return this.getUserName() + "_" + this.getComponentType().toString();
    }

    public boolean isExist(String username, ComponentType component) {
        return this._username.equals(username) && this._componentType.equals((Object)component);
    }

    @JsonProperty(value="password")
    public String getPassword() {
        return this._password;
    }

    @JsonProperty(value="tables")
    public List<String> getTables() {
        return this._tables;
    }

    @JsonProperty(value="permissions")
    public List<AccessType> getPermissios() {
        return this._permissions;
    }

    @JsonProperty(value="component")
    public ComponentType getComponentType() {
        return this._componentType;
    }

    @JsonProperty(value="role")
    public RoleType getRoleType() {
        return this._roleType;
    }

    public void setRole(String roleTypeStr) {
        this._roleType = RoleType.valueOf(roleTypeStr);
    }

    public void setPassword(String password) {
        this._password = password;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserConfig that = (UserConfig)o;
        return this._username.equals(that._username) && this._componentType == that._componentType;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this._username, this._componentType});
    }
}

