/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.ml;

import com.google.common.collect.ImmutableList;
import io.trino.spi.block.Block;
import io.trino.spi.block.BufferedMapValueBuilder;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.SqlType;
import io.trino.spi.function.TypeParameter;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.Type;
import java.util.List;

public final class MLFeaturesFunctions {
    public static final List<Class<?>> ML_FEATURE_FUNCTIONS = ImmutableList.of(Features1.class, Features2.class, Features3.class, Features4.class, Features5.class, Features6.class, Features7.class, Features8.class, Features9.class, Features10.class);
    private static final String MAP_BIGINT_DOUBLE = "map(bigint,double)";

    private MLFeaturesFunctions() {
    }

    private static Block featuresHelper(BufferedMapValueBuilder mapValueBuilder, double ... features) {
        return mapValueBuilder.build(features.length, (keyBuilder, valueBuilder) -> {
            for (int i = 0; i < features.length; ++i) {
                BigintType.BIGINT.writeLong(keyBuilder, (long)i);
                DoubleType.DOUBLE.writeDouble(valueBuilder, features[i]);
            }
        });
    }

    @ScalarFunction(value="features")
    public static class Features1 {
        private final BufferedMapValueBuilder mapValueBuilder;

        public Features1(@TypeParameter(value="map(bigint,double)") Type mapType) {
            this.mapValueBuilder = BufferedMapValueBuilder.createBuffered((MapType)((MapType)mapType));
        }

        @SqlType(value="map(bigint,double)")
        public Block features(@SqlType(value="double") double f1) {
            return MLFeaturesFunctions.featuresHelper(this.mapValueBuilder, f1);
        }
    }

    @ScalarFunction(value="features")
    public static class Features2 {
        private final BufferedMapValueBuilder mapValueBuilder;

        public Features2(@TypeParameter(value="map(bigint,double)") Type mapType) {
            this.mapValueBuilder = BufferedMapValueBuilder.createBuffered((MapType)((MapType)mapType));
        }

        @SqlType(value="map(bigint,double)")
        public Block features(@SqlType(value="double") double f1, @SqlType(value="double") double f2) {
            return MLFeaturesFunctions.featuresHelper(this.mapValueBuilder, f1, f2);
        }
    }

    @ScalarFunction(value="features")
    public static class Features3 {
        private final BufferedMapValueBuilder mapValueBuilder;

        public Features3(@TypeParameter(value="map(bigint,double)") Type mapType) {
            this.mapValueBuilder = BufferedMapValueBuilder.createBuffered((MapType)((MapType)mapType));
        }

        @SqlType(value="map(bigint,double)")
        public Block features(@SqlType(value="double") double f1, @SqlType(value="double") double f2, @SqlType(value="double") double f3) {
            return MLFeaturesFunctions.featuresHelper(this.mapValueBuilder, f1, f2, f3);
        }
    }

    @ScalarFunction(value="features")
    public static class Features4 {
        private final BufferedMapValueBuilder mapValueBuilder;

        public Features4(@TypeParameter(value="map(bigint,double)") Type mapType) {
            this.mapValueBuilder = BufferedMapValueBuilder.createBuffered((MapType)((MapType)mapType));
        }

        @SqlType(value="map(bigint,double)")
        public Block features(@SqlType(value="double") double f1, @SqlType(value="double") double f2, @SqlType(value="double") double f3, @SqlType(value="double") double f4) {
            return MLFeaturesFunctions.featuresHelper(this.mapValueBuilder, f1, f2, f3, f4);
        }
    }

    @ScalarFunction(value="features")
    public static class Features5 {
        private final BufferedMapValueBuilder mapValueBuilder;

        public Features5(@TypeParameter(value="map(bigint,double)") Type mapType) {
            this.mapValueBuilder = BufferedMapValueBuilder.createBuffered((MapType)((MapType)mapType));
        }

        @SqlType(value="map(bigint,double)")
        public Block features(@SqlType(value="double") double f1, @SqlType(value="double") double f2, @SqlType(value="double") double f3, @SqlType(value="double") double f4, @SqlType(value="double") double f5) {
            return MLFeaturesFunctions.featuresHelper(this.mapValueBuilder, f1, f2, f3, f4, f5);
        }
    }

    @ScalarFunction(value="features")
    public static class Features6 {
        private final BufferedMapValueBuilder mapValueBuilder;

        public Features6(@TypeParameter(value="map(bigint,double)") Type mapType) {
            this.mapValueBuilder = BufferedMapValueBuilder.createBuffered((MapType)((MapType)mapType));
        }

        @SqlType(value="map(bigint,double)")
        public Block features(@SqlType(value="double") double f1, @SqlType(value="double") double f2, @SqlType(value="double") double f3, @SqlType(value="double") double f4, @SqlType(value="double") double f5, @SqlType(value="double") double f6) {
            return MLFeaturesFunctions.featuresHelper(this.mapValueBuilder, f1, f2, f3, f4, f5, f6);
        }
    }

    @ScalarFunction(value="features")
    public static class Features7 {
        private final BufferedMapValueBuilder mapValueBuilder;

        public Features7(@TypeParameter(value="map(bigint,double)") Type mapType) {
            this.mapValueBuilder = BufferedMapValueBuilder.createBuffered((MapType)((MapType)mapType));
        }

        @SqlType(value="map(bigint,double)")
        public Block features(@SqlType(value="double") double f1, @SqlType(value="double") double f2, @SqlType(value="double") double f3, @SqlType(value="double") double f4, @SqlType(value="double") double f5, @SqlType(value="double") double f6, @SqlType(value="double") double f7) {
            return MLFeaturesFunctions.featuresHelper(this.mapValueBuilder, f1, f2, f3, f4, f5, f6, f7);
        }
    }

    @ScalarFunction(value="features")
    public static class Features8 {
        private final BufferedMapValueBuilder mapValueBuilder;

        public Features8(@TypeParameter(value="map(bigint,double)") Type mapType) {
            this.mapValueBuilder = BufferedMapValueBuilder.createBuffered((MapType)((MapType)mapType));
        }

        @SqlType(value="map(bigint,double)")
        public Block features(@SqlType(value="double") double f1, @SqlType(value="double") double f2, @SqlType(value="double") double f3, @SqlType(value="double") double f4, @SqlType(value="double") double f5, @SqlType(value="double") double f6, @SqlType(value="double") double f7, @SqlType(value="double") double f8) {
            return MLFeaturesFunctions.featuresHelper(this.mapValueBuilder, f1, f2, f3, f4, f5, f6, f7, f8);
        }
    }

    @ScalarFunction(value="features")
    public static class Features9 {
        private final BufferedMapValueBuilder mapValueBuilder;

        public Features9(@TypeParameter(value="map(bigint,double)") Type mapType) {
            this.mapValueBuilder = BufferedMapValueBuilder.createBuffered((MapType)((MapType)mapType));
        }

        @SqlType(value="map(bigint,double)")
        public Block features(@SqlType(value="double") double f1, @SqlType(value="double") double f2, @SqlType(value="double") double f3, @SqlType(value="double") double f4, @SqlType(value="double") double f5, @SqlType(value="double") double f6, @SqlType(value="double") double f7, @SqlType(value="double") double f8, @SqlType(value="double") double f9) {
            return MLFeaturesFunctions.featuresHelper(this.mapValueBuilder, f1, f2, f3, f4, f5, f6, f7, f8, f9);
        }
    }

    @ScalarFunction(value="features")
    public static class Features10 {
        private final BufferedMapValueBuilder mapValueBuilder;

        public Features10(@TypeParameter(value="map(bigint,double)") Type mapType) {
            this.mapValueBuilder = BufferedMapValueBuilder.createBuffered((MapType)((MapType)mapType));
        }

        @SqlType(value="map(bigint,double)")
        public Block features(@SqlType(value="double") double f1, @SqlType(value="double") double f2, @SqlType(value="double") double f3, @SqlType(value="double") double f4, @SqlType(value="double") double f5, @SqlType(value="double") double f6, @SqlType(value="double") double f7, @SqlType(value="double") double f8, @SqlType(value="double") double f9, @SqlType(value="double") double f10) {
            return MLFeaturesFunctions.featuresHelper(this.mapValueBuilder, f1, f2, f3, f4, f5, f6, f7, f8, f9, f10);
        }
    }
}

