/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.formats.line.sequence;

import com.google.common.base.Preconditions;
import io.trino.filesystem.TrinoInputFile;
import io.trino.hive.formats.line.FooterAwareLineReader;
import io.trino.hive.formats.line.LineBuffer;
import io.trino.hive.formats.line.LineReader;
import io.trino.hive.formats.line.LineReaderFactory;
import io.trino.hive.formats.line.sequence.SequenceFileReader;
import java.io.IOException;

public class SequenceFileReaderFactory
implements LineReaderFactory {
    private final int initialLineBufferSize;
    private final int maxLineLength;

    public SequenceFileReaderFactory(int initialLineBufferSize, int maxLineLength) {
        this.initialLineBufferSize = initialLineBufferSize;
        this.maxLineLength = maxLineLength;
    }

    @Override
    public String getHiveOutputFormatClassName() {
        return "org.apache.hadoop.mapred.SequenceFileInputFormat";
    }

    @Override
    public LineBuffer createLineBuffer() {
        return new LineBuffer(this.initialLineBufferSize, this.maxLineLength);
    }

    @Override
    public LineReader createLineReader(TrinoInputFile inputFile, long start, long length, int headerCount, int footerCount) throws IOException {
        LineReader lineReader = new SequenceFileReader(inputFile, start, length);
        if (headerCount > 0) {
            Preconditions.checkArgument((start == 0L || headerCount == 1 ? 1 : 0) != 0, (Object)"file cannot be split when there is more than one header row");
            if (start == 0L) {
                this.skipHeader(lineReader, headerCount);
            }
        }
        if (footerCount > 0) {
            Preconditions.checkArgument((start == 0L ? 1 : 0) != 0, (Object)"file cannot be split when there are footer rows");
            lineReader = new FooterAwareLineReader(lineReader, footerCount, this::createLineBuffer);
        }
        return lineReader;
    }

    private void skipHeader(LineReader lineReader, int headerCount) throws IOException {
        LineBuffer lineBuffer = this.createLineBuffer();
        for (int i = 0; i < headerCount; ++i) {
            if (lineReader.readLine(lineBuffer)) continue;
            return;
        }
    }
}

