/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.formats.avro;

import org.apache.avro.file.CodecFactory;

public enum AvroCompressionKind {
    NULL("null", CodecFactory.nullCodec() != null),
    DEFLATE("deflate", CodecFactory.deflateCodec((int)-1) != null),
    SNAPPY("snappy", CodecFactory.snappyCodec() != null),
    ZSTANDARD("zstandard", CodecFactory.zstandardCodec((int)3, (boolean)false) != null);

    private final String codecString;
    private final boolean supportedLocally;

    private AvroCompressionKind(String codecString, boolean supportedLocally) {
        this.codecString = codecString;
        this.supportedLocally = supportedLocally;
    }

    public String toString() {
        return this.codecString;
    }

    public CodecFactory getCodecFactory() {
        return CodecFactory.fromString((String)this.codecString);
    }

    public boolean isSupportedLocally() {
        return this.supportedLocally;
    }
}

