/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.memory;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.datasketches.memory.BBWritableBufferImpl;
import org.apache.datasketches.memory.BaseWritableBufferImpl;
import org.apache.datasketches.memory.BaseWritableMemoryImpl;
import org.apache.datasketches.memory.NonNativeWritableBufferImpl;

final class BBNonNativeWritableBufferImpl
extends NonNativeWritableBufferImpl {
    private static final int id = 120;
    private final Object unsafeObj;
    private final long nativeBaseOffset;
    private final ByteBuffer byteBuf;
    private final byte typeId;

    BBNonNativeWritableBufferImpl(Object unsafeObj, long nativeBaseOffset, long regionOffset, long capacityBytes, int typeId, ByteBuffer byteBuf, BaseWritableMemoryImpl originMemory) {
        super(unsafeObj, nativeBaseOffset, regionOffset, capacityBytes, originMemory);
        this.unsafeObj = unsafeObj;
        this.nativeBaseOffset = nativeBaseOffset;
        this.byteBuf = byteBuf;
        this.typeId = (byte)(0x78 | typeId & 7);
    }

    @Override
    BaseWritableBufferImpl toWritableRegion(long offsetBytes, long capacityBytes, boolean readOnly, ByteOrder byteOrder) {
        int type = this.typeId | 2 | (readOnly ? 1 : 0);
        return BBNonNativeWritableBufferImpl.isNativeByteOrder(byteOrder) ? new BBWritableBufferImpl(this.unsafeObj, this.nativeBaseOffset, this.getRegionOffset(offsetBytes), capacityBytes, type, this.byteBuf, this.originMemory) : new BBNonNativeWritableBufferImpl(this.unsafeObj, this.nativeBaseOffset, this.getRegionOffset(offsetBytes), capacityBytes, type, this.byteBuf, this.originMemory);
    }

    @Override
    BaseWritableBufferImpl toDuplicate(boolean readOnly, ByteOrder byteOrder) {
        int type = this.typeId | 4 | (readOnly ? 1 : 0);
        return BBNonNativeWritableBufferImpl.isNativeByteOrder(byteOrder) ? new BBWritableBufferImpl(this.unsafeObj, this.nativeBaseOffset, this.getRegionOffset(), this.getCapacity(), type, this.byteBuf, this.originMemory) : new BBNonNativeWritableBufferImpl(this.unsafeObj, this.nativeBaseOffset, this.getRegionOffset(), this.getCapacity(), type, this.byteBuf, this.originMemory);
    }

    @Override
    public ByteBuffer getByteBuffer() {
        this.assertValid();
        return this.byteBuf;
    }

    @Override
    long getNativeBaseOffset() {
        return this.nativeBaseOffset;
    }

    @Override
    int getTypeId() {
        return this.typeId & 0xFF;
    }

    @Override
    Object getUnsafeObject() {
        this.assertValid();
        return this.unsafeObj;
    }
}

