/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.utils.config;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.helix.HelixManager;
import org.apache.pinot.common.tier.Tier;
import org.apache.pinot.common.tier.TierFactory;
import org.apache.pinot.common.tier.TierSegmentSelector;
import org.apache.pinot.common.tier.TimeBasedTierSegmentSelector;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.config.table.TierConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TierConfigUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(TierConfigUtils.class);

    private TierConfigUtils() {
    }

    public static boolean shouldRelocateToTiers(TableConfig tableConfig) {
        return CollectionUtils.isNotEmpty((Collection)tableConfig.getTierConfigsList());
    }

    public static String normalizeTierName(String tierName) {
        return tierName == null ? "default" : tierName;
    }

    public static String getDataDirForTier(TableConfig tableConfig, String tierName) {
        return TierConfigUtils.getDataDirForTier(tableConfig, tierName, Collections.emptyMap());
    }

    public static String getDataDirForTier(TableConfig tableConfig, String tierName, Map<String, Map<String, String>> instanceTierConfigs) {
        Map<String, String> instanceCfgs;
        String tableNameWithType = tableConfig.getTableName();
        String dataDir = null;
        List tierCfgs = tableConfig.getTierConfigsList();
        if (CollectionUtils.isNotEmpty((Collection)tierCfgs)) {
            TierConfig tierCfg = null;
            for (TierConfig tc : tierCfgs) {
                if (!tierName.equals(tc.getName())) continue;
                tierCfg = tc;
                break;
            }
            if (tierCfg != null) {
                Map backendProps = tierCfg.getTierBackendProperties();
                if (backendProps != null) {
                    dataDir = (String)backendProps.get("dataDir");
                } else {
                    LOGGER.debug("No backend props for tier: {} in TableConfig of table: {}", (Object)tierName, (Object)tableNameWithType);
                }
                if (StringUtils.isNotEmpty((CharSequence)dataDir)) {
                    LOGGER.debug("Got dataDir: {} for tier: {} in TableConfig of table: {}", new Object[]{dataDir, tierName, tableNameWithType});
                    return dataDir;
                }
                LOGGER.debug("No dataDir for tier: {} in TableConfig of table: {}", (Object)tierName, (Object)tableNameWithType);
            }
        }
        if ((instanceCfgs = instanceTierConfigs.get(tierName)) != null) {
            dataDir = instanceCfgs.get("dataDir".toLowerCase());
        }
        Preconditions.checkState((boolean)StringUtils.isNotEmpty(dataDir), (String)"No dataDir for tier: %s for table: %s", (Object)tierName, (Object)tableNameWithType);
        LOGGER.debug("Got dataDir: {} for tier: {} for table: {} in instance configs", new Object[]{dataDir, tierName, tableNameWithType});
        return dataDir;
    }

    public static List<Tier> getSortedTiersForStorageType(List<TierConfig> tierConfigList, String storageType, HelixManager helixManager) {
        ArrayList<Tier> sortedTiers = new ArrayList<Tier>();
        for (TierConfig tierConfig : tierConfigList) {
            if (!storageType.equalsIgnoreCase(tierConfig.getStorageType())) continue;
            sortedTiers.add(TierFactory.getTier(tierConfig, helixManager));
        }
        sortedTiers.sort(TierConfigUtils.getTierComparator());
        return sortedTiers;
    }

    public static List<Tier> getSortedTiers(List<TierConfig> tierConfigList, HelixManager helixManager) {
        ArrayList<Tier> sortedTiers = new ArrayList<Tier>();
        for (TierConfig tierConfig : tierConfigList) {
            sortedTiers.add(TierFactory.getTier(tierConfig, helixManager));
        }
        sortedTiers.sort(TierConfigUtils.getTierComparator());
        return sortedTiers;
    }

    public static Comparator<Tier> getTierComparator() {
        return (o1, o2) -> {
            TierSegmentSelector s1 = o1.getSegmentSelector();
            TierSegmentSelector s2 = o2.getSegmentSelector();
            if ("fixed".equalsIgnoreCase(s1.getType()) && "fixed".equalsIgnoreCase(s2.getType())) {
                return 0;
            }
            if ("fixed".equalsIgnoreCase(s1.getType())) {
                return -1;
            }
            if ("fixed".equalsIgnoreCase(s2.getType())) {
                return 1;
            }
            Long period1 = ((TimeBasedTierSegmentSelector)s1).getSegmentAgeMillis();
            Long period2 = ((TimeBasedTierSegmentSelector)s2).getSegmentAgeMillis();
            return period2.compareTo(period1);
        };
    }
}

