/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.utils.config;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.pinot.spi.utils.CommonConstants;

public class QueryOptionsUtils {
    private static final Map<String, String> CONFIG_RESOLVER;
    private static final RuntimeException CLASS_LOAD_ERROR;

    private QueryOptionsUtils() {
    }

    public static Map<String, String> resolveCaseInsensitiveOptions(Map<String, String> queryOptions) {
        if (CLASS_LOAD_ERROR != null) {
            throw CLASS_LOAD_ERROR;
        }
        HashMap<String, String> resolved = new HashMap<String, String>();
        for (Map.Entry<String, String> configEntry : queryOptions.entrySet()) {
            String config = CONFIG_RESOLVER.get(configEntry.getKey().toLowerCase());
            if (config != null) {
                resolved.put(config, configEntry.getValue());
                continue;
            }
            resolved.put(configEntry.getKey(), configEntry.getValue());
        }
        return resolved;
    }

    @Nullable
    public static Long getTimeoutMs(Map<String, String> queryOptions) {
        String timeoutMsString = queryOptions.get("timeoutMs");
        if (timeoutMsString != null) {
            long timeoutMs = Long.parseLong(timeoutMsString);
            Preconditions.checkState((timeoutMs > 0L ? 1 : 0) != 0, (String)"Query timeout must be positive, got: %s", (long)timeoutMs);
            return timeoutMs;
        }
        return null;
    }

    public static boolean isAndScanReorderingEnabled(Map<String, String> queryOptions) {
        return Boolean.parseBoolean(queryOptions.get("AndScanReordering"));
    }

    public static boolean isSkipUpsert(Map<String, String> queryOptions) {
        return Boolean.parseBoolean(queryOptions.get("skipUpsert"));
    }

    public static boolean isSkipStarTree(Map<String, String> queryOptions) {
        return "false".equalsIgnoreCase(queryOptions.get("useStarTree"));
    }

    public static boolean isRoutingForceHLC(Map<String, String> queryOptions) {
        String routingOptions = queryOptions.get("routingOptions");
        return routingOptions != null && routingOptions.toUpperCase().contains("FORCE_HLC");
    }

    public static boolean isSkipScanFilterReorder(Map<String, String> queryOptions) {
        return "false".equalsIgnoreCase(queryOptions.get("useScanReorderOpt"));
    }

    @Nullable
    public static Integer getNumReplicaGroupsToQuery(Map<String, String> queryOptions) {
        String numReplicaGroupsToQuery = queryOptions.get("numReplicaGroupsToQuery");
        return numReplicaGroupsToQuery != null ? Integer.valueOf(Integer.parseInt(numReplicaGroupsToQuery)) : null;
    }

    public static boolean isExplainPlanVerbose(Map<String, String> queryOptions) {
        return Boolean.parseBoolean(queryOptions.get("explainPlanVerbose"));
    }

    @Nullable
    public static Integer getMaxExecutionThreads(Map<String, String> queryOptions) {
        String maxExecutionThreadsString = queryOptions.get("maxExecutionThreads");
        return maxExecutionThreadsString != null ? Integer.valueOf(Integer.parseInt(maxExecutionThreadsString)) : null;
    }

    @Nullable
    public static Integer getMinSegmentGroupTrimSize(Map<String, String> queryOptions) {
        String minSegmentGroupTrimSizeString = queryOptions.get("minSegmentGroupTrimSize");
        return minSegmentGroupTrimSizeString != null ? Integer.valueOf(Integer.parseInt(minSegmentGroupTrimSizeString)) : null;
    }

    @Nullable
    public static Integer getMinServerGroupTrimSize(Map<String, String> queryOptions) {
        String minServerGroupTrimSizeString = queryOptions.get("minServerGroupTrimSize");
        return minServerGroupTrimSizeString != null ? Integer.valueOf(Integer.parseInt(minServerGroupTrimSizeString)) : null;
    }

    public static boolean isNullHandlingEnabled(Map<String, String> queryOptions) {
        return Boolean.parseBoolean(queryOptions.get("enableNullHandling"));
    }

    public static boolean isServerReturnFinalResult(Map<String, String> queryOptions) {
        return Boolean.parseBoolean(queryOptions.get("serverReturnFinalResult"));
    }

    @Nullable
    public static String getOrderByAlgorithm(Map<String, String> queryOptions) {
        return queryOptions.get("orderByAlgorithm");
    }

    static {
        HashMap<String, String> configResolver = new HashMap<String, String>();
        IllegalAccessException classLoadError = null;
        try {
            for (Field declaredField : CommonConstants.Broker.Request.QueryOptionKey.class.getDeclaredFields()) {
                int mods;
                if (!declaredField.getType().equals(String.class) || !Modifier.isStatic(mods = declaredField.getModifiers()) || !Modifier.isFinal(mods)) continue;
                String config = (String)declaredField.get(null);
                configResolver.put(config.toLowerCase(), config);
            }
        }
        catch (IllegalAccessException e) {
            configResolver = null;
            classLoadError = e;
        }
        CONFIG_RESOLVER = configResolver == null ? null : ImmutableMap.copyOf(configResolver);
        CLASS_LOAD_ERROR = classLoadError == null ? null : new RuntimeException("Failure to build case insensitive mapping.", classLoadError);
    }
}

