/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.response.broker;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.pinot.common.exception.QueryException;
import org.apache.pinot.common.response.BrokerResponse;
import org.apache.pinot.common.response.ProcessingException;
import org.apache.pinot.common.response.broker.QueryProcessingException;
import org.apache.pinot.common.response.broker.ResultTable;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.spi.utils.JsonUtils;

@JsonPropertyOrder(value={"resultTable", "exceptions", "numServersQueried", "numServersResponded", "numSegmentsQueried", "numSegmentsProcessed", "numSegmentsMatched", "numConsumingSegmentsQueried", "numConsumingSegmentsProcessed", "numConsumingSegmentsMatched", "numDocsScanned", "numEntriesScannedInFilter", "numEntriesScannedPostFilter", "numGroupsLimitReached", "totalDocs", "timeUsedMs", "offlineThreadCpuTimeNs", "realtimeThreadCpuTimeNs", "offlineSystemActivitiesCpuTimeNs", "realtimeSystemActivitiesCpuTimeNs", "offlineResponseSerializationCpuTimeNs", "realtimeResponseSerializationCpuTimeNs", "offlineTotalCpuTimeNs", "realtimeTotalCpuTimeNs", "segmentStatistics", "traceInfo"})
public class BrokerResponseNative
implements BrokerResponse {
    public static final BrokerResponseNative EMPTY_RESULT = BrokerResponseNative.empty();
    public static final BrokerResponseNative NO_TABLE_RESULT = new BrokerResponseNative(QueryException.BROKER_RESOURCE_MISSING_ERROR);
    public static final BrokerResponseNative TABLE_DOES_NOT_EXIST = new BrokerResponseNative(QueryException.TABLE_DOES_NOT_EXIST_ERROR);
    public static final BrokerResponseNative BROKER_ONLY_EXPLAIN_PLAN_OUTPUT = BrokerResponseNative.getBrokerResponseExplainPlanOutput();
    private int _numServersQueried = 0;
    private int _numServersResponded = 0;
    private long _numDocsScanned = 0L;
    private long _numEntriesScannedInFilter = 0L;
    private long _numEntriesScannedPostFilter = 0L;
    private long _numSegmentsQueried = 0L;
    private long _numSegmentsProcessed = 0L;
    private long _numSegmentsMatched = 0L;
    private long _numConsumingSegmentsQueried = 0L;
    private long _numConsumingSegmentsProcessed = 0L;
    private long _numConsumingSegmentsMatched = 0L;
    private long _minConsumingFreshnessTimeMs = 0L;
    private long _totalDocs = 0L;
    private boolean _numGroupsLimitReached = false;
    private long _timeUsedMs = 0L;
    private long _offlineThreadCpuTimeNs = 0L;
    private long _realtimeThreadCpuTimeNs = 0L;
    private long _offlineSystemActivitiesCpuTimeNs = 0L;
    private long _realtimeSystemActivitiesCpuTimeNs = 0L;
    private long _offlineResponseSerializationCpuTimeNs = 0L;
    private long _realtimeResponseSerializationCpuTimeNs = 0L;
    private long _offlineTotalCpuTimeNs = 0L;
    private long _realtimeTotalCpuTimeNs = 0L;
    private long _numSegmentsPrunedByBroker = 0L;
    private long _numSegmentsPrunedByServer = 0L;
    private long _numSegmentsPrunedInvalid = 0L;
    private long _numSegmentsPrunedByLimit = 0L;
    private long _numSegmentsPrunedByValue = 0L;
    private long _explainPlanNumEmptyFilterSegments = 0L;
    private long _explainPlanNumMatchAllFilterSegments = 0L;
    private int _numRowsResultSet = 0;
    private ResultTable _resultTable;
    private Map<String, String> _traceInfo = new HashMap<String, String>();
    private List<QueryProcessingException> _processingExceptions = new ArrayList<QueryProcessingException>();
    private List<String> _segmentStatistics = new ArrayList<String>();

    public BrokerResponseNative() {
    }

    public BrokerResponseNative(ProcessingException exception) {
        this._processingExceptions.add(new QueryProcessingException(exception.getErrorCode(), exception.getMessage()));
    }

    public BrokerResponseNative(List<ProcessingException> exceptions) {
        for (ProcessingException exception : exceptions) {
            this._processingExceptions.add(new QueryProcessingException(exception.getErrorCode(), exception.getMessage()));
        }
    }

    private static BrokerResponseNative getBrokerResponseExplainPlanOutput() {
        BrokerResponseNative brokerResponse = BrokerResponseNative.empty();
        ArrayList<Object[]> rows = new ArrayList<Object[]>();
        rows.add(new Object[]{"BROKER_EVALUATE", 0, -1});
        brokerResponse.setResultTable(new ResultTable(DataSchema.EXPLAIN_RESULT_SCHEMA, rows));
        return brokerResponse;
    }

    public static BrokerResponseNative empty() {
        return new BrokerResponseNative();
    }

    public static BrokerResponseNative fromJsonString(String jsonString) throws IOException {
        return (BrokerResponseNative)JsonUtils.stringToObject((String)jsonString, BrokerResponseNative.class);
    }

    @Override
    @JsonProperty(value="offlineSystemActivitiesCpuTimeNs")
    public long getOfflineSystemActivitiesCpuTimeNs() {
        return this._offlineSystemActivitiesCpuTimeNs;
    }

    @Override
    @JsonProperty(value="offlineSystemActivitiesCpuTimeNs")
    public void setOfflineSystemActivitiesCpuTimeNs(long offlineSystemActivitiesCpuTimeNs) {
        this._offlineSystemActivitiesCpuTimeNs = offlineSystemActivitiesCpuTimeNs;
    }

    @Override
    @JsonProperty(value="realtimeSystemActivitiesCpuTimeNs")
    public long getRealtimeSystemActivitiesCpuTimeNs() {
        return this._realtimeSystemActivitiesCpuTimeNs;
    }

    @Override
    @JsonProperty(value="realtimeSystemActivitiesCpuTimeNs")
    public void setRealtimeSystemActivitiesCpuTimeNs(long realtimeSystemActivitiesCpuTimeNs) {
        this._realtimeSystemActivitiesCpuTimeNs = realtimeSystemActivitiesCpuTimeNs;
    }

    @Override
    @JsonProperty(value="offlineThreadCpuTimeNs")
    public long getOfflineThreadCpuTimeNs() {
        return this._offlineThreadCpuTimeNs;
    }

    @Override
    @JsonProperty(value="offlineThreadCpuTimeNs")
    public void setOfflineThreadCpuTimeNs(long timeUsedMs) {
        this._offlineThreadCpuTimeNs = timeUsedMs;
    }

    @Override
    @JsonProperty(value="realtimeThreadCpuTimeNs")
    public long getRealtimeThreadCpuTimeNs() {
        return this._realtimeThreadCpuTimeNs;
    }

    @Override
    @JsonProperty(value="realtimeThreadCpuTimeNs")
    public void setRealtimeThreadCpuTimeNs(long timeUsedMs) {
        this._realtimeThreadCpuTimeNs = timeUsedMs;
    }

    @Override
    @JsonProperty(value="offlineResponseSerializationCpuTimeNs")
    public long getOfflineResponseSerializationCpuTimeNs() {
        return this._offlineResponseSerializationCpuTimeNs;
    }

    @Override
    @JsonProperty(value="offlineResponseSerializationCpuTimeNs")
    public void setOfflineResponseSerializationCpuTimeNs(long offlineResponseSerializationCpuTimeNs) {
        this._offlineResponseSerializationCpuTimeNs = offlineResponseSerializationCpuTimeNs;
    }

    @Override
    @JsonProperty(value="realtimeResponseSerializationCpuTimeNs")
    public long getRealtimeResponseSerializationCpuTimeNs() {
        return this._realtimeResponseSerializationCpuTimeNs;
    }

    @Override
    @JsonProperty(value="realtimeResponseSerializationCpuTimeNs")
    public void setRealtimeResponseSerializationCpuTimeNs(long realtimeResponseSerializationCpuTimeNs) {
        this._realtimeResponseSerializationCpuTimeNs = realtimeResponseSerializationCpuTimeNs;
    }

    @Override
    @JsonProperty(value="offlineTotalCpuTimeNs")
    public long getOfflineTotalCpuTimeNs() {
        return this._offlineTotalCpuTimeNs;
    }

    @Override
    @JsonProperty(value="offlineTotalCpuTimeNs")
    public void setOfflineTotalCpuTimeNs(long offlineTotalCpuTimeNs) {
        this._offlineTotalCpuTimeNs = offlineTotalCpuTimeNs;
    }

    @Override
    @JsonProperty(value="realtimeTotalCpuTimeNs")
    public long getRealtimeTotalCpuTimeNs() {
        return this._realtimeTotalCpuTimeNs;
    }

    @Override
    @JsonProperty(value="realtimeTotalCpuTimeNs")
    public void setRealtimeTotalCpuTimeNs(long realtimeTotalCpuTimeNs) {
        this._realtimeTotalCpuTimeNs = realtimeTotalCpuTimeNs;
    }

    @Override
    @JsonProperty(value="numSegmentsPrunedByBroker")
    public long getNumSegmentsPrunedByBroker() {
        return this._numSegmentsPrunedByBroker;
    }

    @Override
    @JsonProperty(value="numSegmentsPrunedByBroker")
    public void setNumSegmentsPrunedByBroker(long numSegmentsPrunedByBroker) {
        this._numSegmentsPrunedByBroker = numSegmentsPrunedByBroker;
    }

    @Override
    @JsonProperty(value="numSegmentsPrunedByServer")
    public long getNumSegmentsPrunedByServer() {
        return this._numSegmentsPrunedByServer;
    }

    @Override
    @JsonProperty(value="numSegmentsPrunedByServer")
    public void setNumSegmentsPrunedByServer(long numSegmentsPrunedByServer) {
        this._numSegmentsPrunedByServer = numSegmentsPrunedByServer;
    }

    @Override
    @JsonProperty(value="numSegmentsPrunedInvalid")
    public long getNumSegmentsPrunedInvalid() {
        return this._numSegmentsPrunedInvalid;
    }

    @Override
    @JsonProperty(value="numSegmentsPrunedInvalid")
    public void setNumSegmentsPrunedInvalid(long numSegmentsPrunedInvalid) {
        this._numSegmentsPrunedInvalid = numSegmentsPrunedInvalid;
    }

    @Override
    @JsonProperty(value="numSegmentsPrunedByLimit")
    public long getNumSegmentsPrunedByLimit() {
        return this._numSegmentsPrunedByLimit;
    }

    @Override
    @JsonProperty(value="numSegmentsPrunedByLimit")
    public void setNumSegmentsPrunedByLimit(long numSegmentsPrunedByLimit) {
        this._numSegmentsPrunedByLimit = numSegmentsPrunedByLimit;
    }

    @Override
    @JsonProperty(value="numSegmentsPrunedByValue")
    public long getNumSegmentsPrunedByValue() {
        return this._numSegmentsPrunedByValue;
    }

    @Override
    @JsonProperty(value="numSegmentsPrunedByValue")
    public void setNumSegmentsPrunedByValue(long numSegmentsPrunedByValue) {
        this._numSegmentsPrunedByValue = numSegmentsPrunedByValue;
    }

    @Override
    @JsonProperty(value="explainPlanNumEmptyFilterSegments")
    public long getExplainPlanNumEmptyFilterSegments() {
        return this._explainPlanNumEmptyFilterSegments;
    }

    @Override
    @JsonProperty(value="explainPlanNumEmptyFilterSegments")
    public void setExplainPlanNumEmptyFilterSegments(long explainPlanNumEmptyFilterSegments) {
        this._explainPlanNumEmptyFilterSegments = explainPlanNumEmptyFilterSegments;
    }

    @Override
    @JsonProperty(value="explainPlanNumMatchAllFilterSegments")
    public long getExplainPlanNumMatchAllFilterSegments() {
        return this._explainPlanNumMatchAllFilterSegments;
    }

    @Override
    @JsonProperty(value="explainPlanNumMatchAllFilterSegments")
    public void setExplainPlanNumMatchAllFilterSegments(long explainPlanNumMatchAllFilterSegments) {
        this._explainPlanNumMatchAllFilterSegments = explainPlanNumMatchAllFilterSegments;
    }

    @Override
    @JsonProperty(value="resultTable")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public ResultTable getResultTable() {
        return this._resultTable;
    }

    @Override
    @JsonProperty(value="resultTable")
    public void setResultTable(ResultTable resultTable) {
        this._resultTable = resultTable;
        this._numRowsResultSet = resultTable.getRows().size();
    }

    @Override
    @JsonProperty(value="exceptions")
    public List<QueryProcessingException> getProcessingExceptions() {
        return this._processingExceptions;
    }

    @JsonProperty(value="exceptions")
    public void setProcessingExceptions(List<QueryProcessingException> processingExceptions) {
        this._processingExceptions = processingExceptions;
    }

    @Override
    @JsonProperty(value="numServersQueried")
    public int getNumServersQueried() {
        return this._numServersQueried;
    }

    @Override
    @JsonProperty(value="numServersQueried")
    public void setNumServersQueried(int numServersQueried) {
        this._numServersQueried = numServersQueried;
    }

    @Override
    @JsonProperty(value="numServersResponded")
    public int getNumServersResponded() {
        return this._numServersResponded;
    }

    @Override
    @JsonProperty(value="numServersResponded")
    public void setNumServersResponded(int numServersResponded) {
        this._numServersResponded = numServersResponded;
    }

    @Override
    @JsonProperty(value="numDocsScanned")
    public long getNumDocsScanned() {
        return this._numDocsScanned;
    }

    @JsonProperty(value="numDocsScanned")
    public void setNumDocsScanned(long numDocsScanned) {
        this._numDocsScanned = numDocsScanned;
    }

    @Override
    @JsonProperty(value="numEntriesScannedInFilter")
    public long getNumEntriesScannedInFilter() {
        return this._numEntriesScannedInFilter;
    }

    @JsonProperty(value="numEntriesScannedInFilter")
    public void setNumEntriesScannedInFilter(long numEntriesScannedInFilter) {
        this._numEntriesScannedInFilter = numEntriesScannedInFilter;
    }

    @Override
    @JsonProperty(value="numEntriesScannedPostFilter")
    public long getNumEntriesScannedPostFilter() {
        return this._numEntriesScannedPostFilter;
    }

    @JsonProperty(value="numEntriesScannedPostFilter")
    public void setNumEntriesScannedPostFilter(long numEntriesScannedPostFilter) {
        this._numEntriesScannedPostFilter = numEntriesScannedPostFilter;
    }

    @Override
    @JsonProperty(value="numSegmentsQueried")
    public long getNumSegmentsQueried() {
        return this._numSegmentsQueried;
    }

    @JsonProperty(value="numSegmentsQueried")
    public void setNumSegmentsQueried(long numSegmentsQueried) {
        this._numSegmentsQueried = numSegmentsQueried;
    }

    @Override
    @JsonProperty(value="numSegmentsProcessed")
    public long getNumSegmentsProcessed() {
        return this._numSegmentsProcessed;
    }

    @JsonProperty(value="numSegmentsProcessed")
    public void setNumSegmentsProcessed(long numSegmentsProcessed) {
        this._numSegmentsProcessed = numSegmentsProcessed;
    }

    @Override
    @JsonProperty(value="numSegmentsMatched")
    public long getNumSegmentsMatched() {
        return this._numSegmentsMatched;
    }

    @JsonProperty(value="numSegmentsMatched")
    public void setNumSegmentsMatched(long numSegmentsMatched) {
        this._numSegmentsMatched = numSegmentsMatched;
    }

    @Override
    @JsonProperty(value="numConsumingSegmentsQueried")
    public long getNumConsumingSegmentsQueried() {
        return this._numConsumingSegmentsQueried;
    }

    @JsonProperty(value="numConsumingSegmentsQueried")
    public void setNumConsumingSegmentsQueried(long numConsumingSegmentsQueried) {
        this._numConsumingSegmentsQueried = numConsumingSegmentsQueried;
    }

    @Override
    @JsonProperty(value="numConsumingSegmentsProcessed")
    public long getNumConsumingSegmentsProcessed() {
        return this._numConsumingSegmentsProcessed;
    }

    @JsonProperty(value="numConsumingSegmentsProcessed")
    public void setNumConsumingSegmentsProcessed(long numConsumingSegmentsProcessed) {
        this._numConsumingSegmentsProcessed = numConsumingSegmentsProcessed;
    }

    @Override
    @JsonProperty(value="numConsumingSegmentsMatched")
    public long getNumConsumingSegmentsMatched() {
        return this._numConsumingSegmentsMatched;
    }

    @JsonProperty(value="numConsumingSegmentsMatched")
    public void setNumConsumingSegmentsMatched(long numConsumingSegmentsMatched) {
        this._numConsumingSegmentsMatched = numConsumingSegmentsMatched;
    }

    @Override
    @JsonProperty(value="minConsumingFreshnessTimeMs")
    public long getMinConsumingFreshnessTimeMs() {
        return this._minConsumingFreshnessTimeMs;
    }

    @JsonProperty(value="minConsumingFreshnessTimeMs")
    public void setMinConsumingFreshnessTimeMs(long minConsumingFreshnessTimeMs) {
        this._minConsumingFreshnessTimeMs = minConsumingFreshnessTimeMs;
    }

    @Override
    @JsonProperty(value="totalDocs")
    public long getTotalDocs() {
        return this._totalDocs;
    }

    @JsonProperty(value="totalDocs")
    public void setTotalDocs(long totalDocs) {
        this._totalDocs = totalDocs;
    }

    @Override
    @JsonProperty(value="numGroupsLimitReached")
    public boolean isNumGroupsLimitReached() {
        return this._numGroupsLimitReached;
    }

    @JsonProperty(value="numGroupsLimitReached")
    public void setNumGroupsLimitReached(boolean numGroupsLimitReached) {
        this._numGroupsLimitReached = numGroupsLimitReached;
    }

    @JsonProperty(value="timeUsedMs")
    public long getTimeUsedMs() {
        return this._timeUsedMs;
    }

    @Override
    @JsonProperty(value="timeUsedMs")
    public void setTimeUsedMs(long timeUsedMs) {
        this._timeUsedMs = timeUsedMs;
    }

    @Override
    @JsonProperty(value="numRowsResultSet")
    public int getNumRowsResultSet() {
        return this._numRowsResultSet;
    }

    @Override
    @JsonProperty(value="numRowsResultSet")
    public void setNumRowsResultSet(int numRowsResultSet) {
        this._numRowsResultSet = numRowsResultSet;
    }

    @JsonProperty(value="segmentStatistics")
    public List<String> getSegmentStatistics() {
        return this._segmentStatistics;
    }

    @JsonProperty(value="segmentStatistics")
    public void setSegmentStatistics(List<String> segmentStatistics) {
        this._segmentStatistics = segmentStatistics;
    }

    @JsonProperty(value="traceInfo")
    public Map<String, String> getTraceInfo() {
        return this._traceInfo;
    }

    @JsonProperty(value="traceInfo")
    public void setTraceInfo(Map<String, String> traceInfo) {
        this._traceInfo = traceInfo;
    }

    @Override
    public String toJsonString() throws IOException {
        return JsonUtils.objectToString((Object)this);
    }

    @Override
    @JsonIgnore
    public void setExceptions(List<ProcessingException> exceptions) {
        for (ProcessingException exception : exceptions) {
            this._processingExceptions.add(new QueryProcessingException(exception.getErrorCode(), exception.getMessage()));
        }
    }

    public void addToExceptions(QueryProcessingException processingException) {
        this._processingExceptions.add(processingException);
    }

    @Override
    @JsonIgnore
    public int getExceptionsSize() {
        return this._processingExceptions.size();
    }
}

