/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.messages;

import java.util.Map;
import java.util.UUID;
import org.apache.helix.model.Message;
import org.apache.helix.zookeeper.datamodel.ZNRecord;

public class RunPeriodicTaskMessage
extends Message {
    public static final String RUN_PERIODIC_TASK_MSG_SUB_TYPE = "RUN_PERIODIC_TASK";
    private static final String PERIODIC_TASK_REQUEST_ID = "requestId";
    private static final String PERIODIC_TASK_NAME_KEY = "taskName";
    private static final String TABLE_NAME_WITH_TYPE_KEY = "tableNameWithType";
    private static final String TASK_PROPERTIES = "taskProperties";

    public RunPeriodicTaskMessage(String taskRequestId, String periodicTaskName, String tableNameWithType, Map<String, String> taskProperties) {
        super(Message.MessageType.USER_DEFINE_MSG, UUID.randomUUID().toString());
        this.setMsgSubType(RUN_PERIODIC_TASK_MSG_SUB_TYPE);
        this.setExecutionTimeout(-1);
        ZNRecord znRecord = this.getRecord();
        znRecord.setSimpleField(PERIODIC_TASK_REQUEST_ID, taskRequestId);
        znRecord.setSimpleField(PERIODIC_TASK_NAME_KEY, periodicTaskName);
        znRecord.setSimpleField(TABLE_NAME_WITH_TYPE_KEY, tableNameWithType);
        if (taskProperties != null) {
            znRecord.setMapField(TASK_PROPERTIES, taskProperties);
        }
    }

    public RunPeriodicTaskMessage(Message message) {
        super(message.getRecord());
    }

    public String getPeriodicTaskRequestId() {
        return this.getRecord().getSimpleField(PERIODIC_TASK_REQUEST_ID);
    }

    public String getPeriodicTaskName() {
        return this.getRecord().getSimpleField(PERIODIC_TASK_NAME_KEY);
    }

    public String getTableNameWithType() {
        return this.getRecord().getSimpleField(TABLE_NAME_WITH_TYPE_KEY);
    }

    public Map<String, String> getTaskProperties() {
        return this.getRecord().getMapField(TASK_PROPERTIES);
    }
}

