/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.function.scalar;

import java.sql.Timestamp;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.pinot.common.function.DateTimePatternHandler;
import org.apache.pinot.common.function.DateTimeUtils;
import org.apache.pinot.common.function.TimeZoneKey;
import org.apache.pinot.spi.annotations.ScalarFunction;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.chrono.ISOChronology;

public class DateTimeFunctions {
    private DateTimeFunctions() {
    }

    @ScalarFunction
    public static long toEpochSeconds(long millis) {
        return TimeUnit.MILLISECONDS.toSeconds(millis);
    }

    @ScalarFunction
    public static long toEpochMinutes(long millis) {
        return TimeUnit.MILLISECONDS.toMinutes(millis);
    }

    @ScalarFunction
    public static long toEpochHours(long millis) {
        return TimeUnit.MILLISECONDS.toHours(millis);
    }

    @ScalarFunction
    public static long toEpochDays(long millis) {
        return TimeUnit.MILLISECONDS.toDays(millis);
    }

    @ScalarFunction
    public static long toEpochSecondsRounded(long millis, long roundToNearest) {
        return TimeUnit.MILLISECONDS.toSeconds(millis) / roundToNearest * roundToNearest;
    }

    @ScalarFunction
    public static long toEpochMinutesRounded(long millis, long roundToNearest) {
        return TimeUnit.MILLISECONDS.toMinutes(millis) / roundToNearest * roundToNearest;
    }

    @ScalarFunction
    public static long toEpochHoursRounded(long millis, long roundToNearest) {
        return TimeUnit.MILLISECONDS.toHours(millis) / roundToNearest * roundToNearest;
    }

    @ScalarFunction
    public static long toEpochDaysRounded(long millis, long roundToNearest) {
        return TimeUnit.MILLISECONDS.toDays(millis) / roundToNearest * roundToNearest;
    }

    @ScalarFunction
    public static long toEpochSecondsBucket(long millis, long bucket) {
        return TimeUnit.MILLISECONDS.toSeconds(millis) / bucket;
    }

    @ScalarFunction
    public static long toEpochMinutesBucket(long millis, long bucket) {
        return TimeUnit.MILLISECONDS.toMinutes(millis) / bucket;
    }

    @ScalarFunction
    public static long toEpochHoursBucket(long millis, long bucket) {
        return TimeUnit.MILLISECONDS.toHours(millis) / bucket;
    }

    @ScalarFunction
    public static long toEpochDaysBucket(long millis, long bucket) {
        return TimeUnit.MILLISECONDS.toDays(millis) / bucket;
    }

    @ScalarFunction
    public static long fromEpochSeconds(long seconds) {
        return TimeUnit.SECONDS.toMillis(seconds);
    }

    @ScalarFunction
    public static long fromEpochMinutes(long minutes) {
        return TimeUnit.MINUTES.toMillis(minutes);
    }

    @ScalarFunction
    public static long fromEpochHours(long hours) {
        return TimeUnit.HOURS.toMillis(hours);
    }

    @ScalarFunction
    public static long fromEpochDays(long days) {
        return TimeUnit.DAYS.toMillis(days);
    }

    @ScalarFunction
    public static long fromEpochSecondsBucket(long seconds, long bucket) {
        return TimeUnit.SECONDS.toMillis(seconds * bucket);
    }

    @ScalarFunction
    public static long fromEpochMinutesBucket(long minutes, long bucket) {
        return TimeUnit.MINUTES.toMillis(minutes * bucket);
    }

    @ScalarFunction
    public static long fromEpochHoursBucket(long hours, long bucket) {
        return TimeUnit.HOURS.toMillis(hours * bucket);
    }

    @ScalarFunction
    public static long fromEpochDaysBucket(long days, long bucket) {
        return TimeUnit.DAYS.toMillis(days * bucket);
    }

    @ScalarFunction
    public static Timestamp toTimestamp(long millis) {
        return new Timestamp(millis);
    }

    @ScalarFunction
    public static long fromTimestamp(Timestamp timestamp) {
        return timestamp.getTime();
    }

    @ScalarFunction
    public static String toDateTime(long millis, String pattern) {
        return DateTimePatternHandler.parseEpochMillisToDateTimeString(millis, pattern);
    }

    @ScalarFunction
    public static String toDateTime(long millis, String pattern, String timezoneId) {
        return DateTimePatternHandler.parseEpochMillisToDateTimeString(millis, pattern, timezoneId);
    }

    @ScalarFunction
    public static long fromDateTime(String dateTimeString, String pattern) {
        return DateTimePatternHandler.parseDateTimeStringToEpochMillis(dateTimeString, pattern);
    }

    @ScalarFunction
    public static long fromDateTime(String dateTimeString, String pattern, String timeZoneId) {
        return DateTimePatternHandler.parseDateTimeStringToEpochMillis(dateTimeString, pattern, timeZoneId);
    }

    @ScalarFunction
    public static long round(long timeValue, long roundToNearest) {
        return timeValue / roundToNearest * roundToNearest;
    }

    @ScalarFunction
    public static long now() {
        return System.currentTimeMillis();
    }

    @ScalarFunction
    public static long ago(String periodString) {
        Duration period = Duration.parse(periodString);
        return System.currentTimeMillis() - period.toMillis();
    }

    @ScalarFunction
    public static int timezoneHour(String timezoneId) {
        return DateTimeFunctions.timezoneHour(timezoneId, 0L);
    }

    @ScalarFunction
    public static int timezoneHour(String timezoneId, long millis) {
        return (int)TimeUnit.MILLISECONDS.toHours(DateTimeZone.forID((String)timezoneId).getOffset(millis));
    }

    @ScalarFunction
    public static int timezoneMinute(String timezoneId) {
        return DateTimeFunctions.timezoneMinute(timezoneId, 0L);
    }

    @ScalarFunction
    public static int timezoneMinute(String timezoneId, long millis) {
        return (int)TimeUnit.MILLISECONDS.toMinutes(DateTimeZone.forID((String)timezoneId).getOffset(millis)) % 60;
    }

    @ScalarFunction
    public static int year(long millis) {
        return new DateTime(millis, DateTimeZone.UTC).getYear();
    }

    @ScalarFunction
    public static int year(long millis, String timezoneId) {
        return new DateTime(millis, DateTimeZone.forID((String)timezoneId)).getYear();
    }

    @ScalarFunction(names={"yearOfWeek", "year_of_week", "yow"})
    public static int yearOfWeek(long millis) {
        return new DateTime(millis, DateTimeZone.UTC).getWeekyear();
    }

    @ScalarFunction(names={"yearOfWeek", "year_of_week", "yow"})
    public static int yearOfWeek(long millis, String timezoneId) {
        return new DateTime(millis, DateTimeZone.forID((String)timezoneId)).getWeekyear();
    }

    @ScalarFunction
    public static int quarter(long millis) {
        return (DateTimeFunctions.monthOfYear(millis) - 1) / 3 + 1;
    }

    @ScalarFunction
    public static int quarter(long millis, String timezoneId) {
        return (DateTimeFunctions.monthOfYear(millis, timezoneId) - 1) / 3 + 1;
    }

    @ScalarFunction(names={"month", "month_of_year", "monthOfYear"})
    public static int monthOfYear(long millis) {
        return new DateTime(millis, DateTimeZone.UTC).getMonthOfYear();
    }

    @ScalarFunction(names={"month", "month_of_year", "monthOfYear"})
    public static int monthOfYear(long millis, String timezoneId) {
        return new DateTime(millis, DateTimeZone.forID((String)timezoneId)).getMonthOfYear();
    }

    @ScalarFunction(names={"weekOfYear", "week_of_year", "week"})
    public static int weekOfYear(long millis) {
        return new DateTime(millis, DateTimeZone.UTC).getWeekOfWeekyear();
    }

    @ScalarFunction(names={"weekOfYear", "week_of_year", "week"})
    public static int weekOfYear(long millis, String timezoneId) {
        return new DateTime(millis, DateTimeZone.forID((String)timezoneId)).getWeekOfWeekyear();
    }

    @ScalarFunction(names={"dayOfYear", "day_of_year", "doy"})
    public static int dayOfYear(long millis) {
        return new DateTime(millis, DateTimeZone.UTC).getDayOfYear();
    }

    @ScalarFunction(names={"dayOfYear", "day_of_year", "doy"})
    public static int dayOfYear(long millis, String timezoneId) {
        return new DateTime(millis, DateTimeZone.forID((String)timezoneId)).getDayOfYear();
    }

    @ScalarFunction(names={"day", "dayOfMonth", "day_of_month"})
    public static int dayOfMonth(long millis) {
        return new DateTime(millis, DateTimeZone.UTC).getDayOfMonth();
    }

    @ScalarFunction(names={"day", "dayOfMonth", "day_of_month"})
    public static int dayOfMonth(long millis, String timezoneId) {
        return new DateTime(millis, DateTimeZone.forID((String)timezoneId)).getDayOfMonth();
    }

    @ScalarFunction(names={"dayOfWeek", "day_of_week", "dow"})
    public static int dayOfWeek(long millis) {
        return new DateTime(millis, DateTimeZone.UTC).getDayOfWeek();
    }

    @ScalarFunction(names={"dayOfWeek", "day_of_week", "dow"})
    public static int dayOfWeek(long millis, String timezoneId) {
        return new DateTime(millis, DateTimeZone.forID((String)timezoneId)).getDayOfWeek();
    }

    @ScalarFunction
    public static int hour(long millis) {
        return new DateTime(millis, DateTimeZone.UTC).getHourOfDay();
    }

    @ScalarFunction
    public static int hour(long millis, String timezoneId) {
        return new DateTime(millis, DateTimeZone.forID((String)timezoneId)).getHourOfDay();
    }

    @ScalarFunction
    public static int minute(long millis) {
        return new DateTime(millis, DateTimeZone.UTC).getMinuteOfHour();
    }

    @ScalarFunction
    public static int minute(long millis, String timezoneId) {
        return new DateTime(millis, DateTimeZone.forID((String)timezoneId)).getMinuteOfHour();
    }

    @ScalarFunction
    public static int second(long millis) {
        return new DateTime(millis, DateTimeZone.UTC).getSecondOfMinute();
    }

    @ScalarFunction
    public static int second(long millis, String timezoneId) {
        return new DateTime(millis, DateTimeZone.forID((String)timezoneId)).getSecondOfMinute();
    }

    @ScalarFunction
    public static int millisecond(long millis) {
        return new DateTime(millis, DateTimeZone.UTC).getMillisOfSecond();
    }

    @ScalarFunction
    public static int millisecond(long millis, String timezoneId) {
        return new DateTime(millis, DateTimeZone.forID((String)timezoneId)).getMillisOfSecond();
    }

    @ScalarFunction
    public static long dateTrunc(String unit, long timeValue) {
        return DateTimeFunctions.dateTrunc(unit, timeValue, TimeUnit.MILLISECONDS, ISOChronology.getInstanceUTC(), TimeUnit.MILLISECONDS);
    }

    @ScalarFunction
    public static long dateTrunc(String unit, long timeValue, String inputTimeUnitStr) {
        TimeUnit inputTimeUnit = TimeUnit.valueOf(inputTimeUnitStr);
        return DateTimeFunctions.dateTrunc(unit, timeValue, inputTimeUnit, ISOChronology.getInstanceUTC(), inputTimeUnit);
    }

    @ScalarFunction
    public static long dateTrunc(String unit, long timeValue, String inputTimeUnitStr, String timeZone) {
        TimeUnit inputTimeUnit = TimeUnit.valueOf(inputTimeUnitStr);
        return DateTimeFunctions.dateTrunc(unit, timeValue, inputTimeUnit, DateTimeUtils.getChronology(TimeZoneKey.getTimeZoneKey(timeZone)), inputTimeUnit);
    }

    @ScalarFunction
    public static long dateTrunc(String unit, long timeValue, String inputTimeUnitStr, String timeZone, String outputTimeUnitStr) {
        return DateTimeFunctions.dateTrunc(unit, timeValue, TimeUnit.valueOf(inputTimeUnitStr), DateTimeUtils.getChronology(TimeZoneKey.getTimeZoneKey(timeZone)), TimeUnit.valueOf(outputTimeUnitStr));
    }

    private static long dateTrunc(String unit, long timeValue, TimeUnit inputTimeUnit, ISOChronology chronology, TimeUnit outputTimeUnit) {
        return outputTimeUnit.convert(DateTimeUtils.getTimestampField(chronology, unit).roundFloor(TimeUnit.MILLISECONDS.convert(timeValue, inputTimeUnit)), TimeUnit.MILLISECONDS);
    }

    @ScalarFunction(names={"timestampAdd", "dateAdd"})
    public static long timestampAdd(String unit, long interval, long timestamp) {
        ISOChronology chronology = ISOChronology.getInstanceUTC();
        long millis = DateTimeUtils.getTimestampField(chronology, unit).add(timestamp, interval);
        return millis;
    }

    @ScalarFunction(names={"timestampDiff", "dateDiff"})
    public static long timestampDiff(String unit, long timestamp1, long timestamp2) {
        ISOChronology chronology = ISOChronology.getInstanceUTC();
        return DateTimeUtils.getTimestampField(chronology, unit).getDifferenceAsLong(timestamp2, timestamp1);
    }
}

