/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.raptor.legacy.util;

import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import java.util.Objects;
import org.jdbi.v3.core.result.ResultIterator;
import org.jdbi.v3.core.statement.StatementContext;

public class SynchronizedResultIterator<T>
implements ResultIterator<T> {
    @GuardedBy(value="this")
    private final ResultIterator<T> iterator;
    @GuardedBy(value="this")
    private boolean closed;

    public SynchronizedResultIterator(ResultIterator<T> iterator) {
        this.iterator = Objects.requireNonNull(iterator, "iterator is null");
    }

    public synchronized boolean hasNext() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"already closed");
        return this.iterator.hasNext();
    }

    public synchronized T next() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"already closed");
        return (T)this.iterator.next();
    }

    public synchronized void close() {
        if (!this.closed) {
            this.closed = true;
            this.iterator.close();
        }
    }

    public synchronized StatementContext getContext() {
        return this.iterator.getContext();
    }
}

