/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.raptor.legacy.storage;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.memory.context.AggregatedMemoryContext;
import io.trino.orc.OrcDataSource;
import io.trino.orc.OrcRecordReader;
import io.trino.plugin.base.util.Closables;
import io.trino.plugin.raptor.legacy.RaptorColumnHandle;
import io.trino.plugin.raptor.legacy.RaptorErrorCode;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.Page;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.RowBlock;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.spi.type.UuidType;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.UUID;

public class RaptorPageSource
implements ConnectorPageSource {
    private final OrcRecordReader recordReader;
    private final List<ColumnAdaptation> columnAdaptations;
    private final OrcDataSource orcDataSource;
    private final AggregatedMemoryContext memoryContext;
    private boolean closed;

    public RaptorPageSource(OrcRecordReader recordReader, List<ColumnAdaptation> columnAdaptations, OrcDataSource orcDataSource, AggregatedMemoryContext memoryContext) {
        this.recordReader = Objects.requireNonNull(recordReader, "recordReader is null");
        this.columnAdaptations = ImmutableList.copyOf((Collection)Objects.requireNonNull(columnAdaptations, "columnAdaptations is null"));
        this.orcDataSource = Objects.requireNonNull(orcDataSource, "orcDataSource is null");
        this.memoryContext = Objects.requireNonNull(memoryContext, "memoryContext is null");
    }

    public long getCompletedBytes() {
        return this.orcDataSource.getReadBytes();
    }

    public long getReadTimeNanos() {
        return this.orcDataSource.getReadTimeNanos();
    }

    public boolean isFinished() {
        return this.closed;
    }

    public Page getNextPage() {
        Page page;
        try {
            page = this.recordReader.nextPage();
        }
        catch (IOException | RuntimeException e) {
            Closables.closeAllSuppress((Throwable)e, (AutoCloseable[])new AutoCloseable[]{this});
            throw RaptorPageSource.handleException(e);
        }
        if (page == null) {
            this.close();
            return null;
        }
        long filePosition = this.recordReader.getFilePosition();
        Block[] blocks = new Block[this.columnAdaptations.size()];
        for (int i = 0; i < this.columnAdaptations.size(); ++i) {
            blocks[i] = this.columnAdaptations.get(i).block(page, filePosition);
        }
        return new Page(page.getPositionCount(), blocks);
    }

    public static TrinoException handleException(Exception exception) {
        if (exception instanceof TrinoException) {
            return (TrinoException)((Object)exception);
        }
        throw new TrinoException((ErrorCodeSupplier)RaptorErrorCode.RAPTOR_ERROR, (Throwable)exception);
    }

    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        try {
            this.recordReader.close();
        }
        catch (IOException e) {
            throw new TrinoException((ErrorCodeSupplier)RaptorErrorCode.RAPTOR_ERROR, (Throwable)e);
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("columns", this.columnAdaptations).toString();
    }

    public long getMemoryUsage() {
        return this.memoryContext.getBytes();
    }

    public static interface ColumnAdaptation {
        public Block block(Page var1, long var2);

        public static ColumnAdaptation nullColumn(Type type) {
            return new NullColumn(type);
        }

        public static ColumnAdaptation shardUuidColumn(UUID shardUuid) {
            return new ShardUuidAdaptation(shardUuid);
        }

        public static ColumnAdaptation bucketNumberColumn(OptionalInt bucketNumber) {
            if (bucketNumber.isEmpty()) {
                return ColumnAdaptation.nullColumn((Type)IntegerType.INTEGER);
            }
            return new BucketNumberColumn(bucketNumber.getAsInt());
        }

        public static ColumnAdaptation rowIdColumn() {
            return RowIdColumn.INSTANCE;
        }

        public static ColumnAdaptation mergeRowIdColumn(OptionalInt bucketNumber, UUID shardUuid) {
            return new MergeRowIdColumn(bucketNumber, shardUuid);
        }

        public static ColumnAdaptation sourceColumn(int index) {
            return new SourceColumn(index);
        }
    }

    private static class SourceColumn
    implements ColumnAdaptation {
        private final int index;

        public SourceColumn(int index) {
            Preconditions.checkArgument((index >= 0 ? 1 : 0) != 0, (Object)"index is negative");
            this.index = index;
        }

        @Override
        public Block block(Page sourcePage, long filePosition) {
            return sourcePage.getBlock(this.index);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("index", this.index).toString();
        }
    }

    private static class BucketNumberColumn
    implements ColumnAdaptation {
        private final Block bucketNumberBlock;

        public BucketNumberColumn(int bucketNumber) {
            BlockBuilder blockBuilder = IntegerType.INTEGER.createFixedSizeBlockBuilder(1);
            IntegerType.INTEGER.writeLong(blockBuilder, (long)bucketNumber);
            this.bucketNumberBlock = blockBuilder.build();
        }

        @Override
        public Block block(Page sourcePage, long filePosition) {
            return RunLengthEncodedBlock.create((Block)this.bucketNumberBlock, (int)sourcePage.getPositionCount());
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).toString();
        }
    }

    private static class NullColumn
    implements ColumnAdaptation {
        private final Type type;
        private final Block nullBlock;

        public NullColumn(Type type) {
            this.type = Objects.requireNonNull(type, "type is null");
            this.nullBlock = type.createBlockBuilder(null, 1, 0).appendNull().build();
        }

        @Override
        public Block block(Page sourcePage, long filePosition) {
            return RunLengthEncodedBlock.create((Block)this.nullBlock, (int)sourcePage.getPositionCount());
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("type", (Object)this.type).toString();
        }
    }

    private static class MergeRowIdColumn
    implements ColumnAdaptation {
        private final Block bucketNumberValue;
        private final Block shardUuidValue;

        public MergeRowIdColumn(OptionalInt bucketNumber, UUID shardUuid) {
            BlockBuilder blockBuilder = IntegerType.INTEGER.createFixedSizeBlockBuilder(1);
            bucketNumber.ifPresentOrElse(value -> IntegerType.INTEGER.writeLong(blockBuilder, (long)value), () -> ((BlockBuilder)blockBuilder).appendNull());
            this.bucketNumberValue = blockBuilder.build();
            BlockBuilder builder = UuidType.UUID.createFixedSizeBlockBuilder(1);
            UuidType.UUID.writeSlice(builder, UuidType.javaUuidToTrinoUuid((UUID)shardUuid));
            this.shardUuidValue = builder.build();
        }

        @Override
        public Block block(Page sourcePage, long filePosition) {
            Block bucketNumberBlock = RunLengthEncodedBlock.create((Block)this.bucketNumberValue, (int)sourcePage.getPositionCount());
            Block shardUuidBlock = RunLengthEncodedBlock.create((Block)this.shardUuidValue, (int)sourcePage.getPositionCount());
            Block rowIdBlock = RowIdColumn.INSTANCE.block(sourcePage, filePosition);
            return RowBlock.fromFieldBlocks((int)sourcePage.getPositionCount(), (Block[])new Block[]{bucketNumberBlock, shardUuidBlock, rowIdBlock});
        }
    }

    private static class RowIdColumn
    implements ColumnAdaptation {
        public static final RowIdColumn INSTANCE = new RowIdColumn();

        private RowIdColumn() {
        }

        @Override
        public Block block(Page sourcePage, long filePosition) {
            int count = sourcePage.getPositionCount();
            BlockBuilder builder = BigintType.BIGINT.createFixedSizeBlockBuilder(count);
            for (int i = 0; i < count; ++i) {
                BigintType.BIGINT.writeLong(builder, filePosition + (long)i);
            }
            return builder.build();
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).toString();
        }
    }

    private static class ShardUuidAdaptation
    implements ColumnAdaptation {
        private final Block shardUuidBlock;

        public ShardUuidAdaptation(UUID shardUuid) {
            Slice slice = Slices.utf8Slice((String)shardUuid.toString());
            BlockBuilder blockBuilder = RaptorColumnHandle.SHARD_UUID_COLUMN_TYPE.createBlockBuilder(null, 1, slice.length());
            RaptorColumnHandle.SHARD_UUID_COLUMN_TYPE.writeSlice(blockBuilder, slice);
            this.shardUuidBlock = blockBuilder.build();
        }

        @Override
        public Block block(Page sourcePage, long filePosition) {
            return RunLengthEncodedBlock.create((Block)this.shardUuidBlock, (int)sourcePage.getPositionCount());
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).toString();
        }
    }
}

