/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.raptor.legacy.metadata;

import com.google.common.base.MoreObjects;
import com.google.inject.Inject;
import io.trino.plugin.raptor.legacy.metadata.ColumnInfo;
import io.trino.plugin.raptor.legacy.util.DatabaseUtil;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeId;
import io.trino.spi.type.TypeManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Objects;
import java.util.OptionalInt;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.statement.StatementContext;

public class TableColumn {
    private final SchemaTableName table;
    private final String columnName;
    private final Type dataType;
    private final long columnId;
    private final int ordinalPosition;
    private final OptionalInt bucketOrdinal;
    private final OptionalInt sortOrdinal;
    private final boolean temporal;

    public TableColumn(SchemaTableName table, String columnName, Type dataType, long columnId, int ordinalPosition, OptionalInt bucketOrdinal, OptionalInt sortOrdinal, boolean temporal) {
        this.table = Objects.requireNonNull(table, "table is null");
        this.columnName = Objects.requireNonNull(columnName, "columnName is null");
        this.dataType = Objects.requireNonNull(dataType, "dataType is null");
        this.columnId = columnId;
        this.ordinalPosition = ordinalPosition;
        this.bucketOrdinal = Objects.requireNonNull(bucketOrdinal, "bucketOrdinal is null");
        this.sortOrdinal = Objects.requireNonNull(sortOrdinal, "sortOrdinal is null");
        this.temporal = temporal;
    }

    public SchemaTableName getTable() {
        return this.table;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public Type getDataType() {
        return this.dataType;
    }

    public long getColumnId() {
        return this.columnId;
    }

    public int getOrdinalPosition() {
        return this.ordinalPosition;
    }

    public OptionalInt getBucketOrdinal() {
        return this.bucketOrdinal;
    }

    public OptionalInt getSortOrdinal() {
        return this.sortOrdinal;
    }

    public boolean isTemporal() {
        return this.temporal;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("table", (Object)this.table).add("columnId", this.columnId).add("columnName", (Object)this.columnName).add("dataType", (Object)this.dataType).toString();
    }

    public ColumnMetadata toColumnMetadata() {
        return new ColumnMetadata(this.columnName, this.dataType);
    }

    public ColumnInfo toColumnInfo() {
        return new ColumnInfo(this.columnId, this.dataType);
    }

    public static class Mapper
    implements RowMapper<TableColumn> {
        private final TypeManager typeManager;

        @Inject
        public Mapper(TypeManager typeManager) {
            this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        }

        public TableColumn map(ResultSet r, StatementContext ctx) throws SQLException {
            SchemaTableName table = new SchemaTableName(r.getString("schema_name"), r.getString("table_name"));
            String typeName = r.getString("data_type");
            Type type = this.typeManager.getType(TypeId.of((String)typeName));
            return new TableColumn(table, r.getString("column_name"), type, r.getLong("column_id"), r.getInt("ordinal_position"), DatabaseUtil.getOptionalInt(r, "bucket_ordinal_position"), DatabaseUtil.getOptionalInt(r, "sort_ordinal_position"), r.getBoolean("temporal"));
        }
    }
}

