/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.raptor.legacy;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Module;
import io.trino.plugin.raptor.legacy.RaptorConnectorFactory;
import io.trino.plugin.raptor.legacy.metadata.DatabaseMetadataModule;
import io.trino.spi.Plugin;
import io.trino.spi.connector.ConnectorFactory;
import java.util.Map;
import java.util.Objects;

public class RaptorPlugin
implements Plugin {
    private final String name;
    private final Module metadataModule;
    private final Map<String, Module> backupProviders;

    public RaptorPlugin() {
        this("raptor_legacy", (Module)new DatabaseMetadataModule(), (Map<String, Module>)ImmutableMap.of());
    }

    public RaptorPlugin(String name, Module metadataModule, Map<String, Module> backupProviders) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (Object)"name is null or empty");
        this.name = name;
        this.metadataModule = Objects.requireNonNull(metadataModule, "metadataModule is null");
        this.backupProviders = ImmutableMap.copyOf(Objects.requireNonNull(backupProviders, "backupProviders is null"));
    }

    public Iterable<ConnectorFactory> getConnectorFactories() {
        return ImmutableList.of((Object)new RaptorConnectorFactory(this.name, this.metadataModule, this.backupProviders));
    }
}

