/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.raptor.legacy;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.plugin.raptor.legacy.RaptorColumnHandle;
import io.trino.spi.connector.ConnectorInsertTableHandle;
import io.trino.spi.connector.SortOrder;
import io.trino.spi.type.Type;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;

public class RaptorInsertTableHandle
implements ConnectorInsertTableHandle {
    private final long transactionId;
    private final long tableId;
    private final List<RaptorColumnHandle> columnHandles;
    private final List<Type> columnTypes;
    private final Optional<String> externalBatchId;
    private final List<RaptorColumnHandle> sortColumnHandles;
    private final List<SortOrder> sortOrders;
    private final OptionalInt bucketCount;
    private final List<RaptorColumnHandle> bucketColumnHandles;
    private final Optional<RaptorColumnHandle> temporalColumnHandle;

    @JsonCreator
    public RaptorInsertTableHandle(@JsonProperty(value="transactionId") long transactionId, @JsonProperty(value="tableId") long tableId, @JsonProperty(value="columnHandles") List<RaptorColumnHandle> columnHandles, @JsonProperty(value="columnTypes") List<Type> columnTypes, @JsonProperty(value="externalBatchId") Optional<String> externalBatchId, @JsonProperty(value="sortColumnHandles") List<RaptorColumnHandle> sortColumnHandles, @JsonProperty(value="sortOrders") List<SortOrder> sortOrders, @JsonProperty(value="bucketCount") OptionalInt bucketCount, @JsonProperty(value="bucketColumnHandles") List<RaptorColumnHandle> bucketColumnHandles, @JsonProperty(value="temporalColumnHandle") Optional<RaptorColumnHandle> temporalColumnHandle) {
        Preconditions.checkArgument((tableId > 0L ? 1 : 0) != 0, (Object)"tableId must be greater than zero");
        this.transactionId = transactionId;
        this.tableId = tableId;
        this.columnHandles = ImmutableList.copyOf((Collection)Objects.requireNonNull(columnHandles, "columnHandles is null"));
        this.columnTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(columnTypes, "columnTypes is null"));
        this.externalBatchId = Objects.requireNonNull(externalBatchId, "externalBatchId is null");
        this.sortOrders = ImmutableList.copyOf((Collection)Objects.requireNonNull(sortOrders, "sortOrders is null"));
        this.sortColumnHandles = ImmutableList.copyOf((Collection)Objects.requireNonNull(sortColumnHandles, "sortColumnHandles is null"));
        this.bucketCount = Objects.requireNonNull(bucketCount, "bucketCount is null");
        this.bucketColumnHandles = ImmutableList.copyOf((Collection)Objects.requireNonNull(bucketColumnHandles, "bucketColumnHandles is null"));
        this.temporalColumnHandle = Objects.requireNonNull(temporalColumnHandle, "temporalColumnHandle is null");
    }

    @JsonProperty
    public long getTransactionId() {
        return this.transactionId;
    }

    @JsonProperty
    public long getTableId() {
        return this.tableId;
    }

    @JsonProperty
    public List<RaptorColumnHandle> getColumnHandles() {
        return this.columnHandles;
    }

    @JsonProperty
    public List<Type> getColumnTypes() {
        return this.columnTypes;
    }

    @JsonProperty
    public Optional<String> getExternalBatchId() {
        return this.externalBatchId;
    }

    @JsonProperty
    public List<RaptorColumnHandle> getSortColumnHandles() {
        return this.sortColumnHandles;
    }

    @JsonProperty
    public List<SortOrder> getSortOrders() {
        return this.sortOrders;
    }

    @JsonProperty
    public OptionalInt getBucketCount() {
        return this.bucketCount;
    }

    @JsonProperty
    public List<RaptorColumnHandle> getBucketColumnHandles() {
        return this.bucketColumnHandles;
    }

    @JsonProperty
    public Optional<RaptorColumnHandle> getTemporalColumnHandle() {
        return this.temporalColumnHandle;
    }

    public String toString() {
        return String.valueOf(this.tableId);
    }
}

