/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.output.committer.manifest.stages;

import io.trino.hadoop.$internal.org.slf4j.Logger;
import io.trino.hadoop.$internal.org.slf4j.LoggerFactory;
import java.io.IOException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.files.TaskManifest;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.impl.ManifestCommitterSupport;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.stages.AbstractJobOrTaskStage;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.stages.StageConfig;

public class SaveTaskManifestStage
extends AbstractJobOrTaskStage<TaskManifest, Path> {
    private static final Logger LOG = LoggerFactory.getLogger(SaveTaskManifestStage.class);

    public SaveTaskManifestStage(StageConfig stageConfig) {
        super(true, stageConfig, "task_stage_save_manifest", false);
    }

    @Override
    protected Path executeStage(TaskManifest manifest) throws IOException {
        Path manifestDir = this.getTaskManifestDir();
        Path manifestFile = ManifestCommitterSupport.manifestPathForTask(manifestDir, this.getRequiredTaskId());
        Path manifestTempFile = ManifestCommitterSupport.manifestTempPathForTaskAttempt(manifestDir, this.getRequiredTaskAttemptId());
        LOG.info("{}: Saving manifest file to {}", (Object)this.getName(), (Object)manifestFile);
        this.save(manifest, manifestTempFile, manifestFile);
        return manifestFile;
    }
}

