/*
 * Decompiled with CFR 0.152.
 */
package io.trino.orc;

import io.airlift.compress.MalformedInputException;
import io.airlift.compress.zstd.ZstdDecompressor;
import io.trino.orc.OrcCorruptionException;
import io.trino.orc.OrcDataSourceId;
import io.trino.orc.OrcDecompressor;
import java.util.Objects;

class OrcZstdDecompressor
implements OrcDecompressor {
    private final OrcDataSourceId orcDataSourceId;
    private final int maxBufferSize;
    private final ZstdDecompressor decompressor = new ZstdDecompressor();

    public OrcZstdDecompressor(OrcDataSourceId orcDataSourceId, int maxBufferSize) {
        this.orcDataSourceId = Objects.requireNonNull(orcDataSourceId, "orcDataSourceId is null");
        this.maxBufferSize = maxBufferSize;
    }

    @Override
    public int decompress(byte[] input, int offset, int length, OrcDecompressor.OutputBuffer output) throws OrcCorruptionException {
        try {
            long uncompressedLength = ZstdDecompressor.getDecompressedSize((byte[])input, (int)offset, (int)length);
            if (uncompressedLength > (long)this.maxBufferSize) {
                throw new OrcCorruptionException(this.orcDataSourceId, "Zstd requires buffer (%s) larger than max size (%s)", uncompressedLength, this.maxBufferSize);
            }
            byte[] buffer = output.initialize(StrictMath.toIntExact(uncompressedLength));
            return this.decompressor.decompress(input, offset, length, buffer, 0, buffer.length);
        }
        catch (MalformedInputException e) {
            throw new OrcCorruptionException(e, this.orcDataSourceId, "Invalid compressed stream", new Object[0]);
        }
    }

    public String toString() {
        return "zstd";
    }
}

