/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.local;

import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoOutputFile;
import io.trino.filesystem.local.LocalOutputStream;
import io.trino.filesystem.local.LocalUtils;
import io.trino.memory.context.AggregatedMemoryContext;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;

public class LocalOutputFile
implements TrinoOutputFile {
    private final Location location;
    private final Path path;

    public LocalOutputFile(Location location, Path path) {
        this.location = Objects.requireNonNull(location, "location is null");
        this.path = Objects.requireNonNull(path, "path is null");
    }

    public LocalOutputFile(File file) {
        this(Location.of(file.toURI().toString()), file.toPath());
    }

    @Override
    public OutputStream create(AggregatedMemoryContext memoryContext) throws IOException {
        try {
            Files.createDirectories(this.path.getParent(), new FileAttribute[0]);
            OutputStream stream = Files.newOutputStream(this.path, StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);
            return new LocalOutputStream(this.location, stream);
        }
        catch (IOException e) {
            throw LocalUtils.handleException(this.location, e);
        }
    }

    @Override
    public OutputStream createOrOverwrite(AggregatedMemoryContext memoryContext) throws IOException {
        try {
            Files.createDirectories(this.path.getParent(), new FileAttribute[0]);
            OutputStream stream = Files.newOutputStream(this.path, new OpenOption[0]);
            return new LocalOutputStream(this.location, stream);
        }
        catch (IOException e) {
            throw LocalUtils.handleException(this.location, e);
        }
    }

    @Override
    public OutputStream createExclusive(AggregatedMemoryContext memoryContext) throws IOException {
        return this.create(memoryContext);
    }

    @Override
    public Location location() {
        return this.location;
    }

    public String toString() {
        return this.location.toString();
    }
}

