/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.ssl;

import io.trino.hadoop.$internal.org.slf4j.Logger;
import io.trino.hadoop.$internal.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedKeyManager;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.security.ssl.ReloadingX509TrustManager;
import org.apache.hadoop.security.ssl.SSLFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class ReloadingX509KeystoreManager
extends X509ExtendedKeyManager {
    private static final Logger LOG = LoggerFactory.getLogger(ReloadingX509TrustManager.class);
    static final String RELOAD_ERROR_MESSAGE = "Could not load keystore (keep using existing one) : ";
    private final String type;
    private final String storePassword;
    private final String keyPassword;
    private AtomicReference<X509ExtendedKeyManager> keyManagerRef;

    public ReloadingX509KeystoreManager(String type, String location, String storePassword, String keyPassword) throws IOException, GeneralSecurityException {
        this.type = type;
        this.storePassword = storePassword;
        this.keyPassword = keyPassword;
        this.keyManagerRef = new AtomicReference();
        this.keyManagerRef.set(this.loadKeyManager(Paths.get(location, new String[0])));
    }

    @Override
    public String chooseEngineClientAlias(String[] strings, Principal[] principals, SSLEngine sslEngine) {
        return this.keyManagerRef.get().chooseEngineClientAlias(strings, principals, sslEngine);
    }

    @Override
    public String chooseEngineServerAlias(String s2, Principal[] principals, SSLEngine sslEngine) {
        return this.keyManagerRef.get().chooseEngineServerAlias(s2, principals, sslEngine);
    }

    @Override
    public String[] getClientAliases(String s2, Principal[] principals) {
        return this.keyManagerRef.get().getClientAliases(s2, principals);
    }

    @Override
    public String chooseClientAlias(String[] strings, Principal[] principals, Socket socket) {
        return this.keyManagerRef.get().chooseClientAlias(strings, principals, socket);
    }

    @Override
    public String[] getServerAliases(String s2, Principal[] principals) {
        return this.keyManagerRef.get().getServerAliases(s2, principals);
    }

    @Override
    public String chooseServerAlias(String s2, Principal[] principals, Socket socket) {
        return this.keyManagerRef.get().chooseServerAlias(s2, principals, socket);
    }

    @Override
    public X509Certificate[] getCertificateChain(String s2) {
        return this.keyManagerRef.get().getCertificateChain(s2);
    }

    @Override
    public PrivateKey getPrivateKey(String s2) {
        return this.keyManagerRef.get().getPrivateKey(s2);
    }

    public ReloadingX509KeystoreManager loadFrom(Path path) {
        try {
            this.keyManagerRef.set(this.loadKeyManager(path));
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return this;
    }

    private X509ExtendedKeyManager loadKeyManager(Path path) throws IOException, GeneralSecurityException {
        X509ExtendedKeyManager keyManager = null;
        KeyStore keystore = KeyStore.getInstance(this.type);
        KeyManager[] keyManagerArray = null;
        try (InputStream is = Files.newInputStream(path, new OpenOption[0]);){
            keystore.load(is, this.storePassword.toCharArray());
        }
        catch (Throwable object) {
            keyManagerArray = object;
            throw object;
        }
        LOG.debug(" Loaded KeyStore: " + path.toFile().getAbsolutePath());
        KeyManagerFactory keyMgrFactory = KeyManagerFactory.getInstance(SSLFactory.SSLCERTIFICATE);
        keyMgrFactory.init(keystore, this.keyPassword != null ? this.keyPassword.toCharArray() : null);
        for (KeyManager candidate : keyMgrFactory.getKeyManagers()) {
            if (!(candidate instanceof X509ExtendedKeyManager)) continue;
            keyManager = (X509ExtendedKeyManager)candidate;
            break;
        }
        return keyManager;
    }
}

