/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.protocol;

import io.trino.hadoop.$internal.org.apache.hadoop.thirdparty.com.google.common.base.Preconditions;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.protocol.Block;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class BlocksWithLocations {
    private final BlockWithLocations[] blocks;

    public BlocksWithLocations(BlockWithLocations[] blocks) {
        this.blocks = blocks;
    }

    public BlockWithLocations[] getBlocks() {
        return this.blocks;
    }

    public static class StripedBlockWithLocations
    extends BlockWithLocations {
        final byte[] indices;
        final short dataBlockNum;
        final int cellSize;

        public StripedBlockWithLocations(BlockWithLocations blk, byte[] indices, short dataBlockNum, int cellSize) {
            super(blk.getBlock(), blk.getDatanodeUuids(), blk.getStorageIDs(), blk.getStorageTypes());
            Preconditions.checkArgument(blk.getDatanodeUuids().length == indices.length);
            this.indices = indices;
            this.dataBlockNum = dataBlockNum;
            this.cellSize = cellSize;
        }

        public byte[] getIndices() {
            return this.indices;
        }

        public short getDataBlockNum() {
            return this.dataBlockNum;
        }

        public int getCellSize() {
            return this.cellSize;
        }
    }

    @InterfaceAudience.Private
    @InterfaceStability.Evolving
    public static class BlockWithLocations {
        final Block block;
        final String[] datanodeUuids;
        final String[] storageIDs;
        final StorageType[] storageTypes;

        public BlockWithLocations(Block block, String[] datanodeUuids, String[] storageIDs, StorageType[] storageTypes) {
            this.block = block;
            this.datanodeUuids = datanodeUuids;
            this.storageIDs = storageIDs;
            this.storageTypes = storageTypes;
        }

        public Block getBlock() {
            return this.block;
        }

        public String[] getDatanodeUuids() {
            return this.datanodeUuids;
        }

        public String[] getStorageIDs() {
            return this.storageIDs;
        }

        public StorageType[] getStorageTypes() {
            return this.storageTypes;
        }

        public String toString() {
            StringBuilder b = new StringBuilder();
            b.append(this.block);
            if (this.datanodeUuids.length == 0) {
                return b.append("[]").toString();
            }
            this.appendString(0, b.append("["));
            for (int i = 1; i < this.datanodeUuids.length; ++i) {
                this.appendString(i, b.append(","));
            }
            return b.append("]").toString();
        }

        private StringBuilder appendString(int i, StringBuilder b) {
            return b.append("[").append((Object)this.storageTypes[i]).append("]").append(this.storageIDs[i]).append("@").append(this.datanodeUuids[i]);
        }
    }
}

