/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.File;
import java.io.IOException;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.datanode.LocalReplica;
import org.apache.hadoop.hdfs.server.datanode.ReplicaInfo;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsVolumeSpi;
import org.apache.hadoop.hdfs.server.protocol.ReplicaRecoveryInfo;

public class FinalizedReplica
extends LocalReplica {
    private byte[] lastPartialChunkChecksum;
    private int metaLength = -1;

    public FinalizedReplica(long blockId, long len, long genStamp, FsVolumeSpi vol, File dir) {
        this(blockId, len, genStamp, vol, dir, null);
    }

    public FinalizedReplica(long blockId, long len, long genStamp, FsVolumeSpi vol, File dir, byte[] checksum) {
        super(blockId, len, genStamp, vol, dir);
        this.setLastPartialChunkChecksum(checksum);
    }

    public FinalizedReplica(Block block, FsVolumeSpi vol, File dir) {
        this(block, vol, dir, null);
    }

    public FinalizedReplica(Block block, FsVolumeSpi vol, File dir, byte[] checksum) {
        super(block, vol, dir);
        this.setLastPartialChunkChecksum(checksum);
    }

    public FinalizedReplica(FinalizedReplica from) {
        super(from);
        this.setLastPartialChunkChecksum(from.getLastPartialChunkChecksum());
    }

    @Override
    public HdfsServerConstants.ReplicaState getState() {
        return HdfsServerConstants.ReplicaState.FINALIZED;
    }

    @Override
    public long getVisibleLength() {
        return this.getNumBytes();
    }

    @Override
    public long getBytesOnDisk() {
        return this.getNumBytes();
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public String toString() {
        return super.toString();
    }

    @Override
    public ReplicaInfo getOriginalReplica() {
        throw new UnsupportedOperationException("Replica of type " + (Object)((Object)this.getState()) + " does not support getOriginalReplica");
    }

    @Override
    public long getRecoveryID() {
        throw new UnsupportedOperationException("Replica of type " + (Object)((Object)this.getState()) + " does not support getRecoveryID");
    }

    @Override
    public void setRecoveryID(long recoveryId) {
        throw new UnsupportedOperationException("Replica of type " + (Object)((Object)this.getState()) + " does not support setRecoveryID");
    }

    @Override
    public ReplicaRecoveryInfo createInfo() {
        throw new UnsupportedOperationException("Replica of type " + (Object)((Object)this.getState()) + " does not support createInfo");
    }

    @Override
    public long getMetadataLength() {
        if (this.metaLength < 0) {
            this.metaLength = (int)super.getMetadataLength();
        }
        return this.metaLength;
    }

    public byte[] getLastPartialChunkChecksum() {
        return this.lastPartialChunkChecksum;
    }

    public void setLastPartialChunkChecksum(byte[] checksum) {
        this.lastPartialChunkChecksum = checksum;
    }

    public void loadLastPartialChunkChecksum() throws IOException {
        byte[] lastChecksum = this.getVolume().loadLastPartialChunkChecksum(this.getBlockFile(), this.getMetaFile());
        this.setLastPartialChunkChecksum(lastChecksum);
    }
}

