/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.client;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;

public final class JaasKrbUtil {
    public static final boolean ENABLE_DEBUG = false;

    private JaasKrbUtil() {
    }

    public static Subject loginUsingPassword(String principal, String password) throws LoginException {
        HashSet<KerberosPrincipal> principals = new HashSet<KerberosPrincipal>();
        principals.add(new KerberosPrincipal(principal));
        Subject subject = new Subject(false, principals, new HashSet(), new HashSet());
        Configuration conf = JaasKrbUtil.usePassword(principal);
        String confName = "PasswordConf";
        KrbCallbackHandler callback = new KrbCallbackHandler(principal, password);
        LoginContext loginContext = new LoginContext(confName, subject, callback, conf);
        loginContext.login();
        return loginContext.getSubject();
    }

    public static Subject loginUsingTicketCache(String principal, File cacheFile) throws LoginException {
        HashSet<KerberosPrincipal> principals = new HashSet<KerberosPrincipal>();
        principals.add(new KerberosPrincipal(principal));
        Subject subject = new Subject(false, principals, new HashSet(), new HashSet());
        Configuration conf = JaasKrbUtil.useTicketCache(principal, cacheFile);
        String confName = "TicketCacheConf";
        LoginContext loginContext = new LoginContext(confName, subject, null, conf);
        loginContext.login();
        return loginContext.getSubject();
    }

    public static Subject loginUsingKeytab(String principal, File keytabFile) throws LoginException {
        HashSet<KerberosPrincipal> principals = new HashSet<KerberosPrincipal>();
        principals.add(new KerberosPrincipal(principal));
        Subject subject = new Subject(false, principals, new HashSet(), new HashSet());
        Configuration conf = JaasKrbUtil.useKeytab(principal, keytabFile);
        String confName = "KeytabConf";
        LoginContext loginContext = new LoginContext(confName, subject, null, conf);
        loginContext.login();
        return loginContext.getSubject();
    }

    public static Configuration usePassword(String principal) {
        return new PasswordJaasConf(principal);
    }

    public static Configuration useTicketCache(String principal, File credentialFile) {
        return new TicketCacheJaasConf(principal, credentialFile);
    }

    public static Configuration useKeytab(String principal, File keytabFile) {
        return new KeytabJaasConf(principal, keytabFile);
    }

    private static String getKrb5LoginModuleName() {
        return System.getProperty("java.vendor").contains("IBM") ? "com.ibm.security.auth.module.Krb5LoginModule" : "com.sun.security.auth.module.Krb5LoginModule";
    }

    public static class KrbCallbackHandler
    implements CallbackHandler {
        private String principal;
        private String password;

        public KrbCallbackHandler(String principal, String password) {
            this.principal = principal;
            this.password = password;
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (int i = 0; i < callbacks.length; ++i) {
                PasswordCallback pc;
                if (!(callbacks[i] instanceof PasswordCallback) || !(pc = (PasswordCallback)callbacks[i]).getPrompt().contains(this.principal)) continue;
                pc.setPassword(this.password.toCharArray());
                break;
            }
        }
    }

    static class PasswordJaasConf
    extends Configuration {
        private String principal;

        PasswordJaasConf(String principal) {
            this.principal = principal;
        }

        @Override
        public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
            HashMap<String, String> options = new HashMap<String, String>();
            options.put("principal", this.principal);
            options.put("storeKey", "true");
            options.put("useTicketCache", "true");
            options.put("useKeyTab", "false");
            options.put("renewTGT", "true");
            options.put("refreshKrb5Config", "true");
            options.put("isInitiator", "true");
            options.put("debug", String.valueOf(false));
            return new AppConfigurationEntry[]{new AppConfigurationEntry(JaasKrbUtil.getKrb5LoginModuleName(), AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options)};
        }
    }

    static class TicketCacheJaasConf
    extends Configuration {
        private String principal;
        private File clientCredentialFile;

        TicketCacheJaasConf(String principal, File clientCredentialFile) {
            this.principal = principal;
            this.clientCredentialFile = clientCredentialFile;
        }

        @Override
        public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
            HashMap<String, String> options = new HashMap<String, String>();
            options.put("principal", this.principal);
            options.put("storeKey", "false");
            options.put("doNotPrompt", "false");
            options.put("useTicketCache", "true");
            options.put("renewTGT", "true");
            options.put("refreshKrb5Config", "true");
            options.put("isInitiator", "true");
            options.put("ticketCache", this.clientCredentialFile.getAbsolutePath());
            options.put("debug", String.valueOf(false));
            return new AppConfigurationEntry[]{new AppConfigurationEntry(JaasKrbUtil.getKrb5LoginModuleName(), AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options)};
        }
    }

    static class KeytabJaasConf
    extends Configuration {
        private String principal;
        private File keytabFile;

        KeytabJaasConf(String principal, File keytab) {
            this.principal = principal;
            this.keytabFile = keytab;
        }

        @Override
        public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
            HashMap<String, String> options = new HashMap<String, String>();
            options.put("keyTab", this.keytabFile.getAbsolutePath());
            options.put("principal", this.principal);
            options.put("useKeyTab", "true");
            options.put("storeKey", "true");
            options.put("doNotPrompt", "true");
            options.put("renewTGT", "false");
            options.put("refreshKrb5Config", "true");
            options.put("isInitiator", "true");
            options.put("debug", String.valueOf(false));
            return new AppConfigurationEntry[]{new AppConfigurationEntry(JaasKrbUtil.getKrb5LoginModuleName(), AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options)};
        }
    }
}

