/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import java.util.EnumSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.extension.ExtensionFactory;
import org.jdbi.v3.core.extension.ExtensionMetadata;
import org.jdbi.v3.core.extension.Extensions;
import org.jdbi.v3.core.extension.HandleSupplier;
import org.jdbi.v3.core.internal.JdbiClassUtils;
import org.jdbi.v3.core.internal.OnDemandExtensions;
import org.jdbi.v3.sqlobject.AbstractSqlObjectFactory;
import org.jdbi.v3.sqlobject.UnableToCreateSqlObjectException;

final class GeneratorSqlObjectFactory
extends AbstractSqlObjectFactory
implements OnDemandExtensions.Factory {
    private static final Class<?>[] EXTENSION_TYPES = new Class[]{ExtensionMetadata.class, HandleSupplier.class, ConfigRegistry.class};
    private static final Class<?>[] ON_DEMAND_TYPES = new Class[]{Jdbi.class};
    private final ConcurrentMap<Class<?>, JdbiClassUtils.MethodHandleHolder<?>> attachedTypeCache = new ConcurrentHashMap();
    private final ConcurrentMap<Class<?>, JdbiClassUtils.MethodHandleHolder<?>> onDemandTypeCache = new ConcurrentHashMap();

    GeneratorSqlObjectFactory() {
    }

    public boolean accepts(Class<?> extensionType) {
        return GeneratorSqlObjectFactory.isConcrete(extensionType);
    }

    public Set<ExtensionFactory.FactoryFlag> getFactoryFlags() {
        return EnumSet.of(ExtensionFactory.FactoryFlag.DONT_USE_PROXY);
    }

    public <E> E attach(Class<E> extensionType, HandleSupplier handleSupplier) {
        if (!GeneratorSqlObjectFactory.isConcrete(extensionType)) {
            throw new IllegalStateException(String.format("Can not process %s, not generated SQL object", extensionType.getSimpleName()));
        }
        ConfigRegistry config = handleSupplier.getConfig();
        ExtensionMetadata extensionMetaData = ((Extensions)config.get(Extensions.class)).findMetadata(extensionType, (ExtensionFactory)this);
        ConfigRegistry instanceConfig = extensionMetaData.createInstanceConfiguration(config);
        return (E)this.attachedTypeCache.computeIfAbsent(extensionType, GeneratorSqlObjectFactory::getGeneratedClass).invoke(handle -> handle.invokeExact(extensionMetaData, handleSupplier, instanceConfig));
    }

    public Optional<Object> onDemand(Jdbi jdbi, Class<?> extensionType, Class<?> ... extraTypes) {
        if (!GeneratorSqlObjectFactory.isConcrete(extensionType)) {
            return Optional.empty();
        }
        return Optional.of(this.onDemandTypeCache.computeIfAbsent(extensionType, GeneratorSqlObjectFactory::getOnDemandClass).invoke(handle -> handle.invokeExact(jdbi)));
    }

    private static JdbiClassUtils.MethodHandleHolder<?> getGeneratedClass(Class<?> extensionType) {
        try {
            return JdbiClassUtils.findConstructor(Class.forName(GeneratorSqlObjectFactory.getGeneratedClassName(extensionType)), (Class[])EXTENSION_TYPES);
        }
        catch (Throwable t) {
            throw new UnableToCreateSqlObjectException(t);
        }
    }

    private static JdbiClassUtils.MethodHandleHolder<?> getOnDemandClass(Class<?> extensionType) {
        try {
            return JdbiClassUtils.findConstructor(Class.forName(GeneratorSqlObjectFactory.getOnDemandClassName(extensionType)), (Class[])ON_DEMAND_TYPES);
        }
        catch (Throwable t) {
            throw new UnableToCreateSqlObjectException(t);
        }
    }

    private static String getGeneratedClassName(Class<?> extensionType) {
        return extensionType.getPackage().getName() + "." + extensionType.getSimpleName() + "Impl";
    }

    private static String getOnDemandClassName(Class<?> extensionType) {
        return GeneratorSqlObjectFactory.getGeneratedClassName(extensionType) + "$OnDemand";
    }
}

