/*
 * Decompiled with CFR 0.152.
 */
package io.trino.orc.metadata.statistics;

import io.airlift.slice.Slice;
import io.trino.orc.metadata.statistics.BloomFilter;
import io.trino.orc.metadata.statistics.BloomFilterBuilder;

public class Utf8BloomFilterBuilder
implements BloomFilterBuilder {
    private final BloomFilter bloomFilter;

    public Utf8BloomFilterBuilder(int expectedSize, double fpp) {
        this.bloomFilter = new BloomFilter(expectedSize, fpp);
    }

    @Override
    public BloomFilterBuilder addString(Slice val) {
        this.bloomFilter.add(val);
        return this;
    }

    @Override
    public BloomFilterBuilder addLong(long val) {
        this.bloomFilter.addLong(val);
        return this;
    }

    @Override
    public BloomFilterBuilder addDouble(double val) {
        this.bloomFilter.addDouble(val);
        return this;
    }

    @Override
    public BloomFilterBuilder addFloat(float val) {
        this.bloomFilter.addFloat(val);
        return this;
    }

    @Override
    public BloomFilter buildBloomFilter() {
        return this.bloomFilter;
    }
}

