/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.raptor.legacy.storage;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import io.airlift.log.Logger;
import io.airlift.slice.Slice;
import io.airlift.units.Duration;
import io.trino.memory.context.AggregatedMemoryContext;
import io.trino.orc.FileOrcDataSource;
import io.trino.orc.OrcDataSource;
import io.trino.orc.OrcPredicate;
import io.trino.orc.OrcReader;
import io.trino.orc.OrcReaderOptions;
import io.trino.orc.OrcRecordReader;
import io.trino.orc.OrcWriter;
import io.trino.orc.metadata.ColumnMetadata;
import io.trino.orc.metadata.OrcType;
import io.trino.plugin.raptor.legacy.metadata.ColumnInfo;
import io.trino.plugin.raptor.legacy.storage.OrcFileWriter;
import io.trino.plugin.raptor.legacy.storage.RaptorPageSource;
import io.trino.plugin.raptor.legacy.storage.RaptorStorageManager;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.block.DictionaryBlock;
import io.trino.spi.type.TypeManager;
import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTimeZone;

public final class OrcFileRewriter {
    private static final Logger log = Logger.get(OrcFileRewriter.class);

    private OrcFileRewriter() {
    }

    public static OrcFileInfo rewrite(TypeManager typeManager, File input, File output, BitSet rowsToDelete) throws IOException {
        OrcReaderOptions options = new OrcReaderOptions();
        OrcReader reader = (OrcReader)OrcReader.createOrcReader((OrcDataSource)new FileOrcDataSource(input, options), (OrcReaderOptions)options).orElseThrow(() -> new IOException("File is empty: " + input));
        return OrcFileRewriter.rewrite(typeManager, reader, output, rowsToDelete);
    }

    public static OrcFileInfo rewrite(TypeManager typeManager, OrcReader reader, File output, BitSet rowsToDelete) throws IOException {
        OrcFileInfo fileInfo;
        long start = System.nanoTime();
        List<ColumnInfo> columnInfo = RaptorStorageManager.getColumnInfo(typeManager, reader);
        List columnNames = (List)columnInfo.stream().map(info -> String.valueOf(info.getColumnId())).collect(ImmutableList.toImmutableList());
        List columnTypes = (List)columnInfo.stream().map(ColumnInfo::getType).collect(ImmutableList.toImmutableList());
        OrcRecordReader recordReader = reader.createRecordReader(reader.getRootColumn().getNestedColumns(), columnTypes, OrcPredicate.TRUE, DateTimeZone.UTC, AggregatedMemoryContext.newSimpleAggregatedMemoryContext(), 1, RaptorPageSource::handleException);
        long fileRowCount = recordReader.getFileRowCount();
        if (fileRowCount < (long)rowsToDelete.length()) {
            throw new IOException("File has fewer rows than deletion vector");
        }
        int deleteRowCount = rowsToDelete.cardinality();
        if (fileRowCount == (long)deleteRowCount) {
            return new OrcFileInfo(0L, 0L);
        }
        if (fileRowCount >= Integer.MAX_VALUE) {
            throw new IOException("File has too many rows");
        }
        Map metadata = Maps.transformValues((Map)reader.getFooter().getUserMetadata(), Slice::toStringUtf8);
        try (OrcWriter writer = OrcFileWriter.createOrcFileWriter(output, columnNames, columnTypes, (ColumnMetadata<OrcType>)reader.getFooter().getTypes(), metadata);){
            fileInfo = OrcFileRewriter.rewrite(recordReader, writer, rowsToDelete);
        }
        log.debug("Rewrote file in %s (input rows: %s, output rows: %s)", new Object[]{Duration.nanosSince((long)start), fileRowCount, fileRowCount - (long)deleteRowCount});
        return fileInfo;
    }

    private static OrcFileInfo rewrite(OrcRecordReader reader, OrcWriter writer, BitSet rowsToDelete) throws IOException {
        long rowCount = 0L;
        long uncompressedSize = 0L;
        while (true) {
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedIOException();
            }
            Page page = reader.nextPage();
            if (page == null) break;
            int start = Math.toIntExact(reader.getFilePosition());
            page = OrcFileRewriter.maskedPage(page, rowsToDelete, start);
            writer.write(page);
            rowCount += (long)page.getPositionCount();
            uncompressedSize += page.getLogicalSizeInBytes();
        }
        return new OrcFileInfo(rowCount, uncompressedSize);
    }

    private static Page maskedPage(Page page, BitSet rowsToDelete, int start) {
        int end = start + page.getPositionCount();
        if (rowsToDelete.nextSetBit(start) >= end) {
            return page;
        }
        if (rowsToDelete.nextClearBit(start) >= end) {
            return page.copyPositions(new int[0], 0, 0);
        }
        int[] ids = new int[page.getPositionCount()];
        int size = 0;
        for (int i = 0; i < ids.length; ++i) {
            if (rowsToDelete.get(start + i)) continue;
            ids[size] = i;
            ++size;
        }
        Block[] maskedBlocks = new Block[page.getChannelCount()];
        for (int i = 0; i < maskedBlocks.length; ++i) {
            maskedBlocks[i] = DictionaryBlock.create((int)size, (Block)page.getBlock(i), (int[])ids);
        }
        return new Page(maskedBlocks);
    }

    public static class OrcFileInfo {
        private final long rowCount;
        private final long uncompressedSize;

        public OrcFileInfo(long rowCount, long uncompressedSize) {
            this.rowCount = rowCount;
            this.uncompressedSize = uncompressedSize;
        }

        public long getRowCount() {
            return this.rowCount;
        }

        public long getUncompressedSize() {
            return this.uncompressedSize;
        }
    }
}

